package net.darkhax.bookshelf.mixin.patches.entity;

import net.darkhax.bookshelf.api.data.BookshelfTags;
import net.darkhax.bookshelf.api.item.IEquippable;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1309.class)
public abstract class MixinLivingEntity extends class_1297 {

    @Shadow
    protected int lastHurtByPlayerTime;

    @Shadow
    private int lastHurtByMobTimestamp;

    /**
     * This patch allows mobs killed by Bookshelf's fake player damage to drop EXP and player specific loot. Bookshelf's
     * fake player damage is not connected to a specific entity instance so the timers responsible for these checks are
     * not updated otherwise.
     */
    @Inject(method = "hurt", at = @At("HEAD"))
    private void updateFakePlayerDamageTimes(class_1282 source, float amount, CallbackInfoReturnable<Boolean> callback) {
        if (!this.method_37908().field_9236 && !this.method_5679(source) && source.method_48789(BookshelfTags.DamageTypes.FAKE_PLAYER)) {
            this.lastHurtByPlayerTime = this.field_6012;
            this.lastHurtByMobTimestamp = this.field_6012;
        }
    }

    /**
     * This patch implements an alternative to the vanilla Equipable interface that has access to the ItemStack context
     * and can be implemented on blocks or items. This gives mods greater control over deciding the intended slot and
     * allows blocks to be equipped without defining a custom BlockItem.
     */
    @Inject(method = "getEquipmentSlotForItem(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/entity/EquipmentSlot;", at = @At("HEAD"), cancellable = true)
    private static void getSlotFromStack(class_1799 itemStack, CallbackInfoReturnable<class_1304> callback) {
        final IEquippable equippable = IEquippable.get(itemStack);
        if (equippable != null) {
            callback.setReturnValue(equippable.getEquipmentSlot(itemStack));
        }
    }

    private MixinLivingEntity() {
        super(null, null);
    }
}