package net.darkhax.bookshelf.mixin.patches.entity;

import net.darkhax.bookshelf.api.block.ILightningConductive;
import net.minecraft.class_1538;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(class_1538.class)
public class MixinLightningBolt {

    /**
     * Patches lightning to allow blocks to react to being struck by lightning. Also introduces a system for blocks
     * redirecting lightning to adjacent blocks similar to the vanilla lightning rod block.
     */
    @Inject(method = "powerLightningRod()V", at = @At("RETURN"), locals = LocalCapture.CAPTURE_FAILHARD)
    private void onStrikeBlock(CallbackInfo callback, class_2338 strikePos, class_2680 strikeState) {

        final class_1538 self = (class_1538) (Object) this;
        final class_2248 strikeBlock = strikeState.method_26204();

        // Checks if the block being struck reacts to lightning.
        if (strikeBlock instanceof ILightningConductive extended) {

            ((ILightningConductive) strikeBlock).onDirectLightningStrike(self.method_37908(), strikePos, strikeState, self);
        }

        // Checks if the block redirects lightning to adjacent blocks. This is
        // a hardcoded behaviour of the lightning rod that we expose to other
        // blocks as well.
        if (canRedirect(self.method_37908(), strikePos, strikeState)) {

            for (class_2350 direction : getRedirectionSides(self.method_37908(), strikePos, strikeState)) {

                final class_2338 indirectPos = strikePos.method_10093(direction);
                final class_2680 indirectState = self.method_37908().method_8320(indirectPos);

                if (indirectState.method_26204() instanceof ILightningConductive extended) {

                    extended.onIndirectLightingStrike(self.method_37908(), strikePos, strikeState, indirectPos, indirectState, self);
                }
            }
        }
    }

    @Unique
    private static boolean canRedirect(class_1937 world, class_2338 pos, class_2680 state) {

        return state.method_27852(class_2246.field_27171) || (state.method_26204() instanceof ILightningConductive extended && extended.canRedirectLightning(world, pos, state));
    }

    @Unique
    private static class_2350[] getRedirectionSides(class_1937 world, class_2338 pos, class_2680 state) {

        if (state.method_27852(class_2246.field_27171)) {

            return ILightningConductive.LIGHTNING_REDIRECTION_FACES;
        }

        if (state.method_26204() instanceof ILightningConductive extended) {

            return extended.getLightningRedirectionFaces(world, pos, state);
        }

        return ILightningConductive.NO_REDIRECTION_FACES;
    }
}
