package net.darkhax.bookshelf.impl.registry;

import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.block.IBindRenderLayer;
import net.darkhax.bookshelf.api.item.tab.ITabBuilder;
import net.darkhax.bookshelf.api.item.tab.TabBuilder;
import net.darkhax.bookshelf.api.registry.IContentLoader;
import net.darkhax.bookshelf.api.registry.IRegistryEntries;
import net.darkhax.bookshelf.api.registry.RegistryDataProvider;
import net.darkhax.bookshelf.impl.resources.WrappedReloadListener;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_2248;
import net.minecraft.class_2314;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_7923;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public class ContentLoaderFabric implements IContentLoader {

    @Override
    public void loadContent(RegistryDataProvider content) {

        this.consumeVanillaRegistry(content.blocks, class_7923.field_41175);
        this.consumeVanillaRegistry(content.fluids, class_7923.field_41173);
        this.consumeVanillaRegistry(content.items, class_7923.field_41178);
        this.consumeVanillaRegistry(content.bannerPatterns, class_7923.field_41165);
        this.consumeVanillaRegistry(content.mobEffects, class_7923.field_41174);
        this.consumeVanillaRegistry(content.sounds, class_7923.field_41172);
        this.consumeVanillaRegistry(content.potions, class_7923.field_41179);
        this.consumeVanillaRegistry(content.enchantments, class_7923.field_41176);
        this.consumeVanillaRegistry(content.entities, class_7923.field_41177);
        this.consumeVanillaRegistry(content.blockEntities, class_7923.field_41181);
        this.consumeVanillaRegistry(content.particleTypes, class_7923.field_41180);
        this.consumeVanillaRegistry(content.menus, class_7923.field_41187);
        this.consumeVanillaRegistry(content.recipeSerializers, class_7923.field_41189);
        this.consumeVanillaRegistry(content.paintings, class_7923.field_41182);
        this.consumeVanillaRegistry(content.attributes, class_7923.field_41190);
        this.consumeVanillaRegistry(content.stats, class_7923.field_41193);
        this.consumeVanillaRegistry(content.villagerProfessions, class_7923.field_41195);
        this.consumeRegistry(content.commandArguments, (id, value) -> ArgumentTypeRegistry.registerArgumentType(id, (Class) value.getType(), (class_2314) value.getSerializer().get()));
        this.consumeVanillaRegistry(content.recipeTypes, class_7923.field_41188);

        CommandRegistrationCallback.EVENT.register((dispatcher, access, environment) -> content.commands.build((id, value) -> value.build(dispatcher, access, environment)));

        this.registerTradeData(content.trades.getVillagerTrades());
        this.registerWanderingTrades(content.trades.getCommonWanderingTrades(), content.trades.getRareWanderingTrades());

        this.consumeRegistry(content.dataListeners, (id, value) -> ResourceManagerHelper.get(class_3264.field_14190).registerReloadListener(new WrappedReloadListener(id, value)));

        this.consumeVanillaRegistry(content.creativeTabs, class_7923.field_44687, (id, setup) -> {

            final ITabBuilder builder = new TabBuilder(FabricItemGroup.builder());
            builder.title(class_2561.method_43471("itemGroup.%s.%s".formatted(id.method_12836(), id.method_12832())));
            setup.accept(builder);
            return builder.build();
        });

        if (Services.PLATFORM.isPhysicalClient()) {

            this.loadClient(content);
        }
    }

    private void loadClient(RegistryDataProvider content) {

        this.consumeRegistry(content.resourceListeners, (id, value) -> ResourceManagerHelper.get(class_3264.field_14188).registerReloadListener(new WrappedReloadListener(id, value)));

        for (class_2248 block : content.blocks) {
            if (block instanceof IBindRenderLayer bindLayer) {
                BlockRenderLayerMap.INSTANCE.putBlock(block, bindLayer.getRenderLayerToBind());
            }
        }
    }

    private <T, O> void consumeVanillaRegistry(IRegistryEntries<O> toRegister, class_2378<T> registry, BiFunction<class_2960, O, T> wrapper) {

        toRegister.build((id, value) -> class_2378.method_10230(registry, id, wrapper.apply(id, value)));
    }

    private <T, O> void consumeVanillaRegistry(IRegistryEntries<O> toRegister, class_2378<T> registry, Function<O, T> wrapper) {

        toRegister.build((id, value) -> class_2378.method_10230(registry, id, wrapper.apply(value)));
    }

    private <T> void consumeVanillaRegistry(IRegistryEntries<T> toRegister, class_2378<T> registry) {

        toRegister.build((id, value) -> class_2378.method_10230(registry, id, value));
    }

    private <T> void consumeRegistry(IRegistryEntries<T> toRegister, BiConsumer<class_2960, T> func) {

        toRegister.build(func);
    }

    private void registerTradeData(Map<class_3852, Multimap<Integer, class_3853.class_1652>> villagerTrades) {

        for (Map.Entry<class_3852, Multimap<Integer, class_3853.class_1652>> professionData : villagerTrades.entrySet()) {

            final Int2ObjectMap<class_3853.class_1652[]> professionTrades = class_3853.field_17067.computeIfAbsent(professionData.getKey(), profession -> new Int2ObjectOpenHashMap<>());

            for (int merchantTier : professionData.getValue().keySet()) {

                final List<class_3853.class_1652> tradesForTier = new ArrayList<>(Arrays.asList(professionTrades.getOrDefault(merchantTier, new class_3853.class_1652[0])));
                tradesForTier.addAll(professionData.getValue().get(merchantTier));
                professionTrades.put(merchantTier, tradesForTier.toArray(new class_3853.class_1652[0]));
            }
        }
    }

    private void registerWanderingTrades(List<class_3853.class_1652> commonTrades, List<class_3853.class_1652> rareTrades) {

        if (!commonTrades.isEmpty()) {

            final List<class_3853.class_1652> tradeData = new ArrayList<>(Arrays.asList(class_3853.field_17724.get(1)));
            tradeData.addAll(commonTrades);
            class_3853.field_17724.put(1, tradeData.toArray(new class_3853.class_1652[0]));
        }

        if (!rareTrades.isEmpty()) {

            final List<class_3853.class_1652> tradeData = new ArrayList<>(Arrays.asList(class_3853.field_17724.get(2)));
            tradeData.addAll(rareTrades);
            class_3853.field_17724.put(2, tradeData.toArray(new class_3853.class_1652[0]));
        }
    }
}
