package net.darkhax.bookshelf.impl.gametest;

import com.google.common.base.CaseFormat;
import net.darkhax.bookshelf.Constants;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.data.sound.Sound;
import net.darkhax.bookshelf.api.item.ItemStackBuilder;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.bookshelf.api.util.ItemStackHelper;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1322;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1847;
import net.minecraft.class_1856;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1893;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_2440;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3483;
import net.minecraft.class_3486;
import net.minecraft.class_3489;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_3917;
import net.minecraft.class_4525;
import net.minecraft.class_4529;
import net.minecraft.class_5134;
import net.minecraft.class_5698;
import net.minecraft.class_5712;
import net.minecraft.class_6302;
import net.minecraft.class_6303;
import net.minecraft.class_6862;
import net.minecraft.class_7406;
import net.minecraft.class_7408;
import net.minecraft.class_7440;
import net.minecraft.class_7923;
import org.joml.Vector3f;
import org.joml.Vector4f;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;

public class BookshelfGameTests {

    @class_6303
    public static Collection<class_4529> generate() {

        final Collection<class_4529> testFunctions = new ArrayList<>();

        // Test Java Type Serializers
        testFrom(testFunctions, new TestSerialization<>("boolean", Serializers.BOOLEAN, false, true, true, false));
        testFrom(testFunctions, new TestSerialization<>("byte", Serializers.BYTE, (byte) 1, (byte) 32, (byte) 44, (byte) 0));
        testFrom(testFunctions, new TestSerialization<>("short", Serializers.SHORT, (short) 800, (short) 1337));
        testFrom(testFunctions, new TestSerialization<>("int", Serializers.INT, 54, 23, Integer.MAX_VALUE, 234234, Integer.MIN_VALUE));
        testFrom(testFunctions, new TestSerialization<>("long", Serializers.LONG, 99L, 23441322L, Long.MIN_VALUE, 93249L - 234L, Long.MAX_VALUE));
        testFrom(testFunctions, new TestSerialization<>("float", Serializers.FLOAT, 8f, -23.456f, 789.01f, Float.MAX_VALUE, -11f, Float.MIN_VALUE));
        testFrom(testFunctions, new TestSerialization<>("double", Serializers.DOUBLE, 24.92d, Double.MAX_VALUE, -922321.12345d, Double.MIN_VALUE));
        testFrom(testFunctions, new TestSerialization<>("string", Serializers.STRING, "one", "two", "3", "IV", ".....", "/I", "!@#$%^&*()_-"));
        testFrom(testFunctions, new TestSerialization<>("uuid", Serializers.UUID, UUID.randomUUID(), UUID.fromString("da0317d2-e550-11ec-8fea-0242ac120002"), UUID.randomUUID()));

        // Test Minecraft Type Serializers
        testFrom(testFunctions, new TestSerialization<>("resource_location", Serializers.RESOURCE_LOCATION, new class_2960("hello_world"), new class_2960("test", "two"), new class_2960("test_from", "stuff/things/okay_stuff")));
        testFrom(testFunctions, new TestSerialization<>("item_stack", Serializers.ITEM_STACK, ItemStackHelper::areStacksEquivalent, getTestStacks()));
        testFrom(testFunctions, new TestSerialization<>("nbt_compound_tag", Serializers.COMPOUND_TAG, getTestTags()));
        testFrom(testFunctions, new TestSerialization<>("text_component", Serializers.TEXT, class_2561.method_43471("moon.phase.full").method_27692(class_124.field_1062), class_2561.method_43470("Hello World"), class_2561.method_43470("okay").method_27694(s -> s.method_27704(new class_2960("minecraft:alt")))));
        testFrom(testFunctions, new TestSerialization<>("block_pos", Serializers.BLOCK_POS, new class_2338(1, 2, 3), new class_2338(0, 0, 0), class_2338.method_10092(123456L)));
        testFrom(testFunctions, new TestSerialization<>("ingredient", Serializers.INGREDIENT, BookshelfGameTests::assertEqual, new class_1856[]{class_1856.method_8091(class_1802.field_8062), class_1856.field_9017, class_1856.method_8091(class_1802.field_8713), class_1856.method_8101(new class_1799(class_1802.field_8094)), class_1856.method_8106(class_3489.field_16444)}));
        testFrom(testFunctions, new TestSerialization<>("block_state", Serializers.BLOCK_STATE, class_2246.field_10340.method_9564(), class_2246.field_10034.method_9564(), class_2246.field_10397.method_9564().method_11657(class_2440.field_11358, true)));
        testFrom(testFunctions, new TestSerialization<>("attribute_modifier", Serializers.ATTRIBUTE_MODIFIER, new class_1322("test", 15d, class_1322.class_1323.field_6330), new class_1322(UUID.randomUUID(), "test_2", 9.55d, class_1322.class_1323.field_6328), new class_1322("test3", 35d, class_1322.class_1323.field_6331)));
        testFrom(testFunctions, new TestSerialization<>("effect_instance", Serializers.EFFECT_INSTANCE, new class_1293(class_1294.field_5898, 100, 10), new class_1293(class_1294.field_16595, 10)));
        testFrom(testFunctions, new TestSerialization<>("enchantment_instance", Serializers.ENCHANTMENT_INSTANCE, BookshelfGameTests::assertEncantmentInstanceEqual, new class_1889[]{new class_1889(class_1893.field_9111, 5), new class_1889(class_1893.field_9113, 15), new class_1889(class_1893.field_9106, 2)}));
        testFrom(testFunctions, new TestSerialization<>("Vector3f", Serializers.VECTOR_3F, new Vector3f(1f, 2f, 3f), new Vector3f(-5f, -2f, 44f), new Vector3f(Float.MAX_VALUE, Float.MIN_VALUE, Float.MIN_VALUE)));
        testFrom(testFunctions, new TestSerialization<>("Vector4f", Serializers.VECTOR_4F, new Vector4f(1f, 2f, 3f, 4f), new Vector4f(0f, -22f, -2222f, 0f), new Vector4f(Float.MAX_VALUE, Float.MIN_VALUE, Float.MIN_VALUE, Float.MAX_VALUE)));
        testFrom(testFunctions, new TestSerialization<>("sound", Serializers.SOUND, new Sound(class_3417.field_14707, class_3419.field_15256, 1f, 1f), new Sound(class_3417.field_38369, class_3419.field_15254, 0.5f, 0.222f), new Sound(class_3417.field_15034, class_3419.field_15248, 0.1f, 0.2f)));

        // Test Minecraft Enum Serializers
        testFrom(testFunctions, new TestSerialization<>("item_rarity", Serializers.ITEM_RARITY, class_1814.field_8906, class_1814.field_8904, class_1814.field_8903, class_1814.field_8903));
        testFrom(testFunctions, new TestSerialization<>("enchantment_rarity", Serializers.ENCHANTMENT_RARITY, class_1887.class_1888.field_9087, class_1887.class_1888.field_9087, class_1887.class_1888.field_9088, class_1887.class_1888.field_9090));
        testFrom(testFunctions, new TestSerialization<>("attribute_modifier", Serializers.ATTRIBUTE_OPERATION, class_1322.class_1323.field_6328, class_1322.class_1323.field_6328, class_1322.class_1323.field_6330, class_1322.class_1323.field_6331, class_1322.class_1323.field_6331));
        testFrom(testFunctions, new TestSerialization<>("direction", Serializers.DIRECTION, class_2350.field_11036, class_2350.field_11036, class_2350.field_11033, class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11035));
        testFrom(testFunctions, new TestSerialization<>("axis", Serializers.AXIS, class_2350.class_2351.field_11048, class_2350.class_2351.field_11048, class_2350.class_2351.field_11052, class_2350.class_2351.field_11051, class_2350.class_2351.field_11052));
        testFrom(testFunctions, new TestSerialization<>("plane", Serializers.PLANE, class_2350.class_2353.field_11062, class_2350.class_2353.field_11064, class_2350.class_2353.field_11064, class_2350.class_2353.field_11064, class_2350.class_2353.field_11062));
        testFrom(testFunctions, new TestSerialization<>("mob_category", Serializers.MOB_CATEGORY, class_1311.field_6303, class_1311.field_34447, class_1311.field_6294, class_1311.field_34447, class_1311.field_6302, class_1311.field_17715));
        testFrom(testFunctions, new TestSerialization<>("enchantment_category", Serializers.ENCHANTMENT_CATEGORY, class_1886.field_9068, class_1886.field_9082, class_1886.field_9082));
        testFrom(testFunctions, new TestSerialization<>("dye_color", Serializers.DYE_COLOR, class_1767.field_7963, class_1767.field_7964, class_1767.field_7966));
        testFrom(testFunctions, new TestSerialization<>("sound_category", Serializers.SOUND_CATEGORY, class_3419.field_15256, class_3419.field_15251, class_3419.field_15248));

        // Test Game Registry Serializers
        testFrom(testFunctions, new TestSerialization<>("registry_block", Serializers.BLOCK, class_2246.field_10102, class_2246.field_10340, class_2246.field_9993, class_2246.field_10102));
        testFrom(testFunctions, new TestSerialization<>("registry_item", Serializers.ITEM, class_1802.field_8279, class_1802.field_8600, class_1802.field_8600, class_1802.field_8261));
        testFrom(testFunctions, new TestSerialization<>("registry_enchantment", Serializers.ENCHANTMENT, class_1893.field_9111, class_1893.field_9107, class_1893.field_9107, class_1893.field_9099));
        testFrom(testFunctions, new TestSerialization<>("registry_painting", Serializers.PAINTING, class_7923.field_41182.method_10223(class_7408.field_38955.method_29177()), class_7923.field_41182.method_10223(class_7408.field_38948.method_29177())));
        testFrom(testFunctions, new TestSerialization<>("registry_potion", Serializers.POTION, class_1847.field_8984, class_1847.field_8999, class_1847.field_8999, class_1847.field_8987, class_1847.field_8963));
        testFrom(testFunctions, new TestSerialization<>("registry_attribute", Serializers.ATTRIBUTE, class_5134.field_23724, class_5134.field_23723, class_5134.field_23716, class_5134.field_23727));
        testFrom(testFunctions, new TestSerialization<>("registry_villager_profession", Serializers.VILLAGER_PROFESSION, class_3852.field_17052, class_3852.field_17052, class_3852.field_17053, class_3852.field_17059, class_3852.field_17065));
        testFrom(testFunctions, new TestSerialization<>("registry_villager_type", Serializers.VILLAGER_TYPE, class_3854.field_17076, class_3854.field_17072, class_3854.field_17072, class_3854.field_17073));
        testFrom(testFunctions, new TestSerialization<>("registry_sound_event", Serializers.SOUND_EVENT, class_3417.field_14695, class_3417.field_14635, class_3417.field_14675, class_3417.field_14707));
        testFrom(testFunctions, new TestSerialization<>("registry_menu", Serializers.MENU, class_3917.field_17329, class_3917.field_18665, class_3917.field_17334, class_3917.field_17343));
        testFrom(testFunctions, new TestSerialization<>("registry_particle_type", Serializers.PARTICLE, class_2398.field_11241, class_2398.field_11238, class_2398.field_11204, class_2398.field_17431, class_2398.field_22446));
        testFrom(testFunctions, new TestSerialization<>("registry_entity_type", Serializers.ENTITY, class_1299.field_6108, class_1299.field_6122, class_1299.field_28315, class_1299.field_6129));
        testFrom(testFunctions, new TestSerialization<>("registry_block_entity_type", Serializers.BLOCK_ENTITY, class_2591.field_16411, class_2591.field_11890, class_2591.field_20431, class_2591.field_11907));
        testFrom(testFunctions, new TestSerialization<>("registry_game_event", Serializers.GAME_EVENT, class_5712.field_28157, class_5712.field_28167, class_5712.field_28727, class_5712.field_28152));

        // Test Game Registry Tags
        final class_2960 tagOne = new class_2960("test", "one");
        final class_2960 tagTwo = new class_2960("test", "two");

        testFromTags(testFunctions, "block_tag", Serializers.BLOCK_TAG, class_3481.field_15486, class_3481.field_16443, class_3481.field_25807);
        testFromTags(testFunctions, "item_tag", Serializers.ITEM_TAG, class_3489.field_15547, class_3489.field_28299, class_3489.field_15554);
        testFromTags(testFunctions, "banner_pattern_tag", Serializers.BANNER_PATTERN_TAG, class_7440.field_39097, class_7440.field_39102, class_7440.field_39099);
        testFromTags(testFunctions, "enchantment_tag", Serializers.ENCHANTMENT_TAG, Services.TAGS.enchantmentTag(tagOne), Services.TAGS.enchantmentTag(tagTwo));
        testFromTags(testFunctions, "painting_tag", Serializers.MOTIVE_TAG, class_7406.field_38929, class_7406.field_38929);
        testFromTags(testFunctions, "mob_effect_tag", Serializers.MOB_EFFECT_TAG, Services.TAGS.effectTag(tagOne), Services.TAGS.effectTag(tagTwo));
        testFromTags(testFunctions, "potion_tag", Serializers.POTION_TAG, Services.TAGS.potionTag(tagOne), Services.TAGS.potionTag(tagTwo));
        testFromTags(testFunctions, "attribute_tag", Serializers.ATTRIBUTE_TAG, Services.TAGS.attributeTag(tagOne), Services.TAGS.attributeTag(tagTwo));
        testFromTags(testFunctions, "villager_profession_tag", Serializers.VILLAGER_PROFESSION_TAG, Services.TAGS.villagerProfessionTag(tagOne), Services.TAGS.villagerProfessionTag(tagTwo));
        testFromTags(testFunctions, "villager_type_tag", Serializers.VILLAGER_TYPE_TAG, Services.TAGS.villagerTypeTag(tagOne), Services.TAGS.villagerTypeTag(tagTwo));
        testFromTags(testFunctions, "sound_event_tag", Serializers.SOUND_EVENT_TAG, Services.TAGS.soundTag(tagOne), Services.TAGS.soundTag(tagTwo));
        testFromTags(testFunctions, "menu_tag", Serializers.MENU_TAG, Services.TAGS.menuTag(tagOne), Services.TAGS.menuTag(tagTwo));
        testFromTags(testFunctions, "particle_type_tag", Serializers.PARTICLE_TAG, Services.TAGS.particleTag(tagOne), Services.TAGS.particleTag(tagTwo));
        testFromTags(testFunctions, "entity_type_tag", Serializers.ENTITY_TAG, class_3483.field_21508, class_3483.field_28296, class_3483.field_27855);
        testFromTags(testFunctions, "block_entity_type_tag", Serializers.BLOCK_ENTITY_TAG, Services.TAGS.blockEntityTag(tagOne), Services.TAGS.blockEntityTag(tagTwo));
        testFromTags(testFunctions, "game_event_tag", Serializers.GAME_EVENT_TAG, class_5698.field_28091, class_5698.field_28090, class_5698.field_28090);
        testFromTags(testFunctions, "fluid_tag", Serializers.FLUID_TAG, class_3486.field_15518, class_3486.field_15517);
        testFromTags(testFunctions, "stat_tag", Serializers.STAT_TAG, Services.TAGS.statTag(tagOne), Services.TAGS.statTag(tagTwo));
        testFromTags(testFunctions, "recipe_type_tag", Serializers.RECIPE_TYPE_TAG, Services.TAGS.recipeTypeTag(tagOne), Services.TAGS.recipeTypeTag(tagTwo));
        testFromTags(testFunctions, "recipe_serializer_tag", Serializers.RECIPE_SERIALIZER_TAG, Services.TAGS.recipeSerializerTag(tagOne), Services.TAGS.recipeSerializerTag(tagTwo));
        testFromTags(testFunctions, "dimension_type_tag", Serializers.DIMENSION_TYPE_TAG, Services.TAGS.dimensionTypeTag(tagOne), Services.TAGS.dimensionTypeTag(tagTwo));
        testFromTags(testFunctions, "dimension_tag", Serializers.DIMENSION_TAG, Services.TAGS.dimensionTag(tagOne), Services.TAGS.dimensionTag(tagTwo));
        testFromTags(testFunctions, "biome_tag", Serializers.BIOME_TAG, Services.TAGS.biomeTag(tagOne), Services.TAGS.biomeTag(tagTwo));

        return testFunctions;
    }

    /**
     * Generates tests from a pre-instantiated instance of a class.
     *
     * @param functions The collection to register newly generated functions into.
     * @param testImpl  The implementation of the test class.
     * @param <T>       The type of class to load classes from.
     */
    public static <T> void testFrom(Collection<class_4529> functions, T testImpl) {

        // I like to batch tests from the same instance together in a separate batch. To allow for
        // this I use a new ITestable interface which allows the testImpl to optionally supply a
        // name for the batch. If a test defines its own non-default batch this will be overridden.
        final String parentBatch = testImpl instanceof ITestable testObj ? testObj.getDefaultBatch() : null;

        // TODO This code can not see inherited methods yet.
        for (Method method : testImpl.getClass().getDeclaredMethods()) {

            // Only methods annotated with the vanilla GameTest annotation can be used.
            if (method.isAnnotationPresent(class_6302.class)) {

                // Metadata defined by the annotation on the method.
                final class_6302 annotation = method.getAnnotation(class_6302.class);

                // The namespaced ID of the template to spawn in the world. An empty structure is
                // usually preferred if the test does not interact with the world.
                final String template = annotation.method_35936().isEmpty() ? "bookshelf:empty" : annotation.method_35936();
                final String batch = parentBatch != null && annotation.method_35933().equalsIgnoreCase("defaultBatch") ? parentBatch : annotation.method_35933();
                // I prefer lower snake case for test names but this is not required.
                final String testName = batch + "." + CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, method.getName());
                final class_2470 rotation = class_4525.method_29408(annotation.method_35934());

                functions.add(new class_4529(batch, testName, template, rotation, annotation.method_35932(), annotation.method_35937(), annotation.method_35935(), annotation.method_35939(), annotation.method_35938(), gameTestHelper -> {

                    try {

                        method.invoke(testImpl, gameTestHelper);
                    }

                    // The scanned method could not be executed.
                    catch (IllegalAccessException e) {

                        throw new RuntimeException("Failed to invoke test method (%s) in (%s) because %s".formatted(method.getName(), method.getDeclaringClass().getCanonicalName(), e.getMessage()), e);
                    }

                    // The scanned method was executed but thre an exception.
                    catch (InvocationTargetException e) {

                        // Convert the exception into a RuntimeException, so we can rethrow it.
                        final RuntimeException rte = (e.getCause() instanceof RuntimeException runtimeException) ? runtimeException : new RuntimeException(e.getCause());

                        // The vanilla system likes to swallow these errors, so making an external
                        // paper trail for the exception can be very helpful.
                        Constants.LOG.error("The test {} failed to run!", testName, e);
                        throw rte;
                    }
                }));
            }
        }
    }

    /**
     * A generally unnecessary helper for adding tests for a tag serializer. This primarily exists to simplify generic
     * vararg array issues.
     *
     * @param functions  The collection to register newly generated functions into.
     * @param name       The name of the type being serialized. This is used for debug output.
     * @param serializer The serializer that handles this tag type.
     * @param tags       Arbitrary tags to test serialization with.
     * @param <T>        The type of tag being serialized.
     */
    private static <T> void testFromTags(Collection<class_4529> functions, String name, ISerializer<class_6862<T>> serializer, class_6862<T>... tags) {

        testFrom(functions, new TestSerialization<>(name, serializer, BookshelfGameTests::assertTagEqual, tags));
    }

    /**
     * Checks if two enchantment instance are equal.
     *
     * @param a The original instance to test.
     * @param b The instance that resulted from deserialization.
     * @return Whether the enchantment instances were equal or not.
     */
    private static boolean assertEncantmentInstanceEqual(class_1889 a, class_1889 b) {

        if (Objects.equals(a, b)) {

            return true;
        }

        if (a.field_9093 != b.field_9093) {

            Constants.LOG.error("Enchantment {} != {}", a.field_9093, b.field_9093);
            return false;
        }

        if (a.field_9094 != b.field_9094) {

            Constants.LOG.error("Level {} != {}", a.field_9094, b.field_9094);
            return false;
        }

        return true;
    }

    /**
     * Internal code to test if two tag keys are equal.
     *
     * @param a   The original tag to test.
     * @param b   The tag that resulted from deserialization.
     * @param <T> The type of the tag.
     * @return Whether the tags were equal or not.
     */
    private static <T> boolean assertTagEqual(class_6862<T> a, class_6862<T> b) {

        return Objects.equals(a, b) || Objects.equals(a.comp_327(), b.comp_327());
    }

    /**
     * Internal code to test if two ingredients are equal. This approach is good enough for vanilla ingredients which is
     * all our test cares about, however this is not robust enough for general use, or for use with modded ingredient
     * specs.
     *
     * @param original The original ingredient to test.
     * @param result   The ingredient that resulted from deserialization.
     * @return Whether the ingredients were equal enough or not.
     */
    private static boolean assertEqual(class_1856 original, class_1856 result) {

        if (Objects.equals(original, result)) {

            return true;
        }

        final class_1799[] originalStacks = original.method_8105();
        final class_1799[] resultStacks = result.method_8105();

        if (originalStacks.length != resultStacks.length) {

            Constants.LOG.error("Size mismatch. original={} result={}", originalStacks.length, resultStacks.length);
            return false;
        }

        for (int index = 0; index < originalStacks.length; index++) {

            if (!ItemStackHelper.areStacksEquivalent(originalStacks[index], resultStacks[index])) {

                Constants.LOG.error("Mismatch at index {}. original={} result={}", index, originalStacks[index], resultStacks[index]);

                return false;
            }
        }

        return true;
    }

    private static class_1799[] getTestStacks() {

        return new class_1799[]{
                new class_1799(class_1802.field_20391),
                new class_1799(class_1802.field_8600).method_7977(class_2561.method_43470("test")),
                new class_1799(class_1802.field_8062),
                class_1799.field_8037,
                new ItemStackBuilder(class_1802.field_28408).enchant(class_1893.field_9111).build(),
                new ItemStackBuilder(class_1802.field_8536).name(class_2561.method_43470("HELP")).lore(class_2561.method_43470("hello world")).build()
        };
    }

    private static class_2487[] getTestTags() {

        class_2487 tag1 = new class_2487();
        class_2487 tag2 = new class_2487();
        tag2.method_10566("one", class_2497.method_23247(33));
        tag2.method_10566("two", class_2519.method_23256("hello"));
        class_2487 tag3 = new class_2487();
        tag3.method_10566("one", tag2);
        tag3.method_10566("two", new class_2499());
        return new class_2487[]{
                tag1, tag2, tag3
        };
    }
}