package net.darkhax.bookshelf.impl.data.recipes.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.darkhax.bookshelf.api.Services;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7710;
import net.minecraft.class_8566;

public class ShapelessDurabilityRecipe extends class_1867 {

    public static final Serializer SERIALIZER = new Serializer();

    private final class_1799 output;
    private final int damageAmount;

    public ShapelessDurabilityRecipe(class_2960 recipeId, String group, class_7710 category, class_1799 result, class_2371<class_1856> ingredients, int damageAmount) {

        super(recipeId, group, category, result, ingredients);
        this.damageAmount = damageAmount;
        this.output = result;
    }

    @Override
    public class_2371<class_1799> getRemainingItems(class_8566 inv) {

        final class_2371<class_1799> keptItems = super.method_8111(inv);
        return Services.INVENTORY_HELPER.keepDamageableItems(inv, keptItems, this.damageAmount);
    }

    @Override
    public class_1865<?> method_8119() {

        return SERIALIZER;
    }

    public static class Serializer implements class_1865<ShapelessDurabilityRecipe> {

        @Override
        public ShapelessDurabilityRecipe method_8121(class_2960 recipeId, JsonObject json) {

            final String group = class_3518.method_15253(json, "group", "");
            final class_2371<class_1856> inputs = readIngredients(class_3518.method_15261(json, "ingredients"));
            final class_1799 output = class_1869.method_35228(class_3518.method_15296(json, "result"));
            final int damageAmount = class_3518.method_15282(json, "damageAmount", 1);

            class_7710 category = class_7710.field_40252.method_47920(class_3518.method_15253(json, "category", null), class_7710.field_40251);

            if (inputs.isEmpty()) {

                throw new JsonSyntaxException("No ingredients were found for the recipe!");
            }

            else if (inputs.size() > 9) {

                throw new JsonSyntaxException("Too many ingredients. Maximum is 9 but " + inputs.size() + " were given.");
            }

            else if (output.method_7960()) {

                throw new JsonSyntaxException("The output of the recipe must not be empty!");
            }

            return new ShapelessDurabilityRecipe(recipeId, group, category, output, inputs, damageAmount);
        }

        @Override
        public ShapelessDurabilityRecipe method_8122(class_2960 recipeId, class_2540 buffer) {

            final String group = buffer.method_10800(32767);
            final int inputCount = buffer.method_10816();
            final class_2371<class_1856> inputs = class_2371.method_10213(inputCount, class_1856.field_9017);

            for (int i = 0; i < inputCount; i++) {

                inputs.set(i, class_1856.method_8086(buffer));
            }

            final class_7710 category = buffer.method_10818(class_7710.class);

            final class_1799 output = buffer.method_10819();
            final int damageAmount = buffer.method_10816();

            return new ShapelessDurabilityRecipe(recipeId, group, category,output, inputs, damageAmount);
        }

        @Override
        public void toNetwork(class_2540 buffer, ShapelessDurabilityRecipe toWrite) {

            buffer.method_10814(toWrite.method_8112());
            buffer.method_10804(toWrite.method_8117().size());

            for (final class_1856 ingredient : toWrite.method_8117()) {

                ingredient.method_8088(buffer);
            }

            buffer.method_10817(toWrite.method_45441());

            buffer.method_10793(toWrite.output);
            buffer.method_10804(toWrite.damageAmount);
        }

        private static class_2371<class_1856> readIngredients (JsonArray json) {

            final class_2371<class_1856> ingredients = class_2371.method_10211();

            for (final JsonElement element : json) {

                final class_1856 ingredient = class_1856.method_52177(element);

                if (!ingredient.method_8103()) {

                    ingredients.add(ingredient);
                }
            }

            return ingredients;
        }
    }
}
