package net.darkhax.bookshelf.impl.data.conditions;

import com.google.gson.JsonObject;
import net.darkhax.bookshelf.api.data.conditions.ILoadCondition;
import net.darkhax.bookshelf.api.data.conditions.ILoadConditionSerializer;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1535;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import java.util.List;

/**
 * This condition is only met when all specified registry entries exist in the game registry.
 *
 * @param <T> The type of registry item tested.
 */
public class LoadConditionRegistry<T> implements ILoadConditionSerializer<ILoadCondition> {

    public static final LoadConditionRegistry<class_2248> BLOCK = new LoadConditionRegistry<>(class_7923.field_41175);
    public static final LoadConditionRegistry<class_1792> ITEM = new LoadConditionRegistry<>(class_7923.field_41178);
    public static final LoadConditionRegistry<class_1887> ENCHANTMENT = new LoadConditionRegistry<>(class_7923.field_41176);
    public static final LoadConditionRegistry<class_1535> PAINTING = new LoadConditionRegistry<>(class_7923.field_41182);
    public static final LoadConditionRegistry<class_1291> MOB_EFFECT = new LoadConditionRegistry<>(class_7923.field_41174);
    public static final LoadConditionRegistry<class_1842> POTION = new LoadConditionRegistry<>(class_7923.field_41179);
    public static final LoadConditionRegistry<class_1320> ATTRIBUTE = new LoadConditionRegistry<>(class_7923.field_41190);
    public static final LoadConditionRegistry<class_1299<?>> ENTITY_TYPE = new LoadConditionRegistry<>(class_7923.field_41177);
    public static final LoadConditionRegistry<class_2591<?>> BLOCK_ENTITY_TYPE = new LoadConditionRegistry<>(class_7923.field_41181);

    private final class_2378<T> registry;

    public LoadConditionRegistry(class_2378<T> registry) {

        this.registry = registry;
    }

    @Override
    public ILoadCondition fromJson(JsonObject json) {

        final List<class_2960> ids = Serializers.RESOURCE_LOCATION.fromJSONList(json, "values");

        return () -> {

            for (class_2960 regId : ids) {

                if (!this.registry.method_10250(regId)) {

                    return false;
                }
            }

            return true;
        };
    }
}