package net.darkhax.bookshelf.impl.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.darkhax.bookshelf.api.util.TextHelper;
import net.darkhax.bookshelf.impl.commands.args.FontArgument;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1843;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2196;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2624;
import net.minecraft.class_2625;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_8242;
import java.util.function.UnaryOperator;

public class CommandFont {

    public static LiteralArgumentBuilder<class_2168> build() {

        final LiteralArgumentBuilder<class_2168> font = class_2170.method_9247("font");

        font.then(class_2170.method_9247("item").requires(p -> p.method_9259(2)).then(FontArgument.argument().executes(CommandFont::renameItemWithFont)));
        font.then(class_2170.method_9247("block").requires(p -> p.method_9259(2)).then(FontArgument.argument().then(class_2170.method_9244("pos", class_2262.method_9698()).executes(CommandFont::renameBlockWithFont))));
        font.then(class_2170.method_9247("book").requires(p -> p.method_9259(2)).then(FontArgument.argument().executes(CommandFont::setBookFont)));
        font.then(class_2170.method_9247("say").requires(p -> p.method_9259(2)).then(FontArgument.argument().then(class_2170.method_9244("message", class_2196.method_9340()).executes(CommandFont::speakWithFont))));

        return font;
    }

    private static int speakWithFont(CommandContext<class_2168> context) throws CommandSyntaxException {

        //TODO Consider adding a message decorator or chat type and use signed chat?
        final class_2960 fontId = FontArgument.getFont(context);
        final class_2561 inputMessage = TextHelper.applyFont(class_2196.method_9339(context, "message"), fontId);
        final class_2561 txtMessage = class_2561.method_43469("chat.type.announcement", context.getSource().method_9223(), inputMessage);
        context.getSource().method_9211().method_3760().method_43514(txtMessage, false);
        return 0;
    }

    private static int renameItemWithFont(CommandContext<class_2168> context) {

        final class_2960 fontId = FontArgument.getFont(context);
        final class_1297 sender = context.getSource().method_9228();

        if (sender instanceof class_1309 living) {

            final class_1799 stack = living.method_6047();
            stack.method_7977(TextHelper.applyFont(stack.method_7964(), fontId));
            return 1;
        }

        return 0;
    }

    private static int renameBlockWithFont(CommandContext<class_2168> context) throws CommandSyntaxException {

        final class_3218 world = context.getSource().method_9225();
        final class_2960 fontId = FontArgument.getFont(context);
        final class_2338 pos = class_2262.method_9696(context, "pos");
        final class_2586 tile = world.method_8321(pos);

        if (tile != null) {

            if (tile instanceof class_2624 container) {

                container.method_17488(TextHelper.applyFont(container.method_5477(), fontId));
            }

            if (tile instanceof class_2625 sign) {

                sign.method_49841(applySignFont(fontId), true);
                sign.method_49841(applySignFont(fontId), false);
                sign.method_10997().method_8413(sign.method_11016(), sign.method_11010(), sign.method_11010(), 3);
            }
        }

        return 1;
    }

    private static UnaryOperator<class_8242> applySignFont(class_2960 fontId) {
        return text -> {

            class_8242 newText = text;

            for (int i = 0; i < 4; i++) {

                newText = newText.method_49857(i, TextHelper.applyFont(text.method_49859(i, false).method_27661(), fontId));
            }

            return newText;
        };
    }

    private static int setBookFont(CommandContext<class_2168> context) {

        final class_2960 fontId = FontArgument.getFont(context);
        final class_1297 sender = context.getSource().method_9228();

        if (sender instanceof class_1309 living) {

            final class_1799 stack = living.method_6047();

            if (stack.method_7909() instanceof class_1843 && stack.method_7985()) {

                stack.method_7977(TextHelper.applyFont(stack.method_7964(), fontId));

                final class_2487 stackTag = stack.method_7969();

                if (stackTag != null) {

                    final class_2499 pageData = stackTag.method_10554("pages", class_2520.field_33258);

                    for (int pageNum = 0; pageNum < pageData.size(); pageNum++) {

                        final class_2561 pageText = class_2561.class_2562.method_10873(pageData.method_10608(pageNum));
                        TextHelper.applyFont(pageText, fontId);
                        pageData.method_10606(pageNum, class_2519.method_23256(class_2561.class_2562.method_10867(pageText)));
                    }

                    stackTag.method_10566("pages", pageData);
                }

                return 1;
            }
        }

        return 0;
    }
}
