package net.darkhax.bookshelf.api.util;

import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class RenderHelper {

    public static void renderLinesWrapped(class_332 graphics, int x, int y, class_5348 text, int textWidth) {

        final class_327 font = class_310.method_1551().field_1772;
        renderLinesWrapped(graphics, font, x, y, font.field_2000, 0, text, textWidth);
    }

    public static void renderLinesWrapped(class_332 graphics, class_327 fontRenderer, int x, int y, int spacing, int defaultColor, class_5348 text, int textWidth) {

        renderLinesWrapped(graphics, fontRenderer, x, y, spacing, defaultColor, fontRenderer.method_1728(text, textWidth));
    }

    public static void renderLinesWrapped(class_332 graphics, class_327 font, int x, int y, int spacing, int defaultColor, List<class_5481> lines) {

        for (int lineNum = 0; lineNum < lines.size(); lineNum++) {

            final class_5481 lineFragment = lines.get(lineNum);
            graphics.method_35720(font, lineFragment, x, y + lineNum * spacing, defaultColor);
        }
    }

    public static int renderLinesReversed(class_332 graphics, int x, int y, class_5348 text, int textWidth) {

        final class_327 font = class_310.method_1551().field_1772;
        return renderLinesReversed(graphics, font, x, y, font.field_2000, 0xffffff, text, textWidth);
    }

    public static int renderLinesReversed(class_332 graphics, class_327 font, int x, int y, int spacing, int defaultColor, class_5348 text, int textWidth) {

        return renderLinesReversed(graphics, font, x, y, spacing, defaultColor, font.method_1728(text, textWidth));
    }

    public static int renderLinesReversed(class_332 graphics, class_327 font, int x, int y, int spacing, int defaultColor, List<class_5481> lines) {

        final int lineCount = lines.size();
        for (int lineNum = lineCount - 1; lineNum >= 0; lineNum--) {

            final class_5481 lineFragment = lines.get(lineCount - 1 - lineNum);
            graphics.method_35720(font, lineFragment, x, y - (lineNum + 1) * (spacing + 1), defaultColor);
        }

        return lineCount * (spacing + 1);
    }
}
