package net.darkhax.bookshelf.api.util;

import java.util.Collection;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_5134;

/**
 * This class contains static helper functions for working with entity attributes and calculating attribute values.
 */
public final class AttributeHelper {

    /**
     * Calculates the attack damage attribute value for a given ItemStack.
     *
     * @param stack The ItemStack to calculate values for.
     * @return The attack damage value for the ItemStack.
     */
    public static double getAttackDamage(class_1799 stack) {

        return calculateValue(stack, class_5134.field_23721, class_1304.field_6173);
    }

    /**
     * Calculates the attack speed attribute value for a given ItemStack.
     *
     * @param stack The ItemStack to calculate values for.
     * @return The attack speed value for the ItemStack.
     */
    public static double getAttackSpeed(class_1799 stack) {

        return calculateValue(stack, class_5134.field_23723, class_1304.field_6173);
    }

    /**
     * Calculates the attack knockback attribute value for a given ItemStack.
     *
     * @param stack The ItemStack to calculate values for.
     * @return The attack knockback value for the ItemStack.
     */
    public static double getAttackKnockback(class_1799 stack) {

        return calculateValue(stack, class_5134.field_23722, class_1304.field_6173);
    }

    /**
     * Calculates an attribute value for an ItemStack when used in a given slot.
     *
     * @param stack     The ItemStack to calculate values for.
     * @param attribute The attribute to calculate.
     * @param slot      The equipment slot to calculate for.
     * @return The calculated attribute value.
     */
    public static double calculateValue(class_1799 stack, class_1320 attribute, class_1304 slot) {

        return calculateValue(attribute, stack.method_7926(slot).get(attribute));
    }

    /**
     * Calculates an attribute value using a collection of attribute modifiers.
     *
     * @param attribute The attribute to calculate a value for.
     * @param modifiers A collection of modifiers to process.
     * @return The calculated attribute value.
     */
    public static double calculateValue(class_1320 attribute, Collection<class_1322> modifiers) {

        return attribute.method_6165(calculateValue(modifiers, attribute.method_6169()));
    }

    /**
     * Calculates an attribute value using a collection of attribute modifiers.
     *
     * @param modifiers A collection of modifiers to process.
     * @param baseValue The base value to use for the calculation.
     * @return The calculated attribute value.
     */
    public static double calculateValue(Collection<class_1322> modifiers, double baseValue) {

        double baseTotal = baseValue;

        for (class_1322 modifier : modifiers) {

            if (modifier.method_6182() == class_1322.class_1323.field_6328) {

                baseTotal += modifier.method_6186();
            }
        }

        double modifiedValue = baseTotal;

        for (class_1322 modifier : modifiers) {

            if (modifier.method_6182() == class_1322.class_1323.field_6330) {

                modifiedValue += baseTotal * modifier.method_6186();
            }
        }

        for (class_1322 modifier : modifiers) {

            if (modifier.method_6182() == class_1322.class_1323.field_6331) {

                modifiedValue *= 1 + modifier.method_6186();
            }
        }

        return modifiedValue;
    }
}
