package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import org.joml.Vector4f;

public class SerializerVector4f implements ISerializer<Vector4f> {

    public static final ISerializer<Vector4f> SERIALIZER = new SerializerVector4f();

    @Override
    public Vector4f fromJSON(JsonElement json) {

        // If it's an object explicitly read each axis.
        if (json.isJsonObject()) {

            final JsonObject object = json.getAsJsonObject();
            final float x = Serializers.FLOAT.fromJSON(object, "x");
            final float y = Serializers.FLOAT.fromJSON(object, "y");
            final float z = Serializers.FLOAT.fromJSON(object, "z");
            final float w = Serializers.FLOAT.fromJSON(object, "w");
            return new Vector4f(x, y, z, w);
        }

        // If it's an array of 4 elements read in X,Y,Z,W order.
        else if (json.isJsonArray()) {

            final JsonArray array = json.getAsJsonArray();

            if (array.size() == 4) {

                return new Vector4f(array.get(0).getAsFloat(), array.get(1).getAsFloat(), array.get(2).getAsFloat(), array.get(3).getAsFloat());
            }

            throw new JsonParseException("Invalid number of args in array. Expected 4 but got " + array.size());
        }

        throw new JsonParseException("Vector4f data is not in a readable format.");
    }

    @Override
    public JsonElement toJSON(Vector4f toWrite) {

        final JsonObject object = new JsonObject();
        object.addProperty("x", toWrite.x());
        object.addProperty("y", toWrite.y());
        object.addProperty("z", toWrite.z());
        object.addProperty("w", toWrite.w());
        return object;
    }

    @Override
    public Vector4f fromByteBuf(class_2540 buffer) {

        return new Vector4f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
    }

    @Override
    public void toByteBuf(class_2540 buffer, Vector4f toWrite) {

        buffer.writeFloat(toWrite.x());
        buffer.writeFloat(toWrite.y());
        buffer.writeFloat(toWrite.z());
        buffer.writeFloat(toWrite.w());
    }

    @Override
    public class_2520 toNBT(Vector4f toWrite) {

        final class_2487 tag = new class_2487();
        tag.method_10548("x", toWrite.x());
        tag.method_10548("y", toWrite.y());
        tag.method_10548("z", toWrite.z());
        tag.method_10548("w", toWrite.w());
        return tag;
    }

    @Override
    public Vector4f fromNBT(class_2520 nbt) {

        // If it's a compound explicitly read each axis.
        if (nbt instanceof class_2487 compound) {

            final float x = compound.method_10583("x");
            final float y = compound.method_10583("y");
            final float z = compound.method_10583("z");
            final float w = compound.method_10583("w");
            return new Vector4f(x, y, z, w);
        }

        // If it's a list of 4 elements read in X,Y,Z,W order.
        else if (nbt instanceof class_2499 list) {

            if (list.size() == 4) {

                return new Vector4f(Serializers.FLOAT.fromNBT(list.method_10534(0)), Serializers.FLOAT.fromNBT(list.method_10534(1)), Serializers.FLOAT.fromNBT(list.method_10534(2)), Serializers.FLOAT.fromNBT(list.method_10534(3)));
            }

            throw new NBTParseException("Invalid number of args in array. Expected 4 but got " + list.size());
        }

        throw new NBTParseException("Vector4f data is not in a readable format.");
    }
}