package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import net.minecraft.class_2514;
import net.minecraft.class_2516;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public final class SerializerShort implements ISerializer<Short> {

    public static final ISerializer<Short> SERIALIZER = new SerializerShort();

    private SerializerShort() {

    }

    @Override
    public Short fromJSON(JsonElement json) {

        return json.getAsShort();
    }

    @Override
    public JsonElement toJSON(Short toWrite) {

        return new JsonPrimitive(toWrite);
    }

    @Override
    public Short fromByteBuf(class_2540 buffer) {

        return buffer.readShort();
    }

    @Override
    public void toByteBuf(class_2540 buffer, Short toWrite) {

        buffer.writeShort(toWrite);
    }

    @Override
    public class_2520 toNBT(Short toWrite) {

        return class_2516.method_23254(toWrite);
    }

    @Override
    public Short fromNBT(class_2520 nbt) {

        if (nbt instanceof class_2514 shortTag) {

            return shortTag.method_10696();
        }

        throw new NBTParseException("Expected NBT to be a number tag. Class was " + nbt.getClass() + " with ID " + nbt.method_10711() + " instead.");
    }
}