package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import net.minecraft.class_2378;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class SerializerRegistryEntry<T> implements ISerializer<T> {

    private final class_2378<T> registry;

    public SerializerRegistryEntry(class_2378<T> registry) {

        this.registry = registry;
    }

    @Override
    public T fromJSON(JsonElement json) {

        final class_2960 id = Serializers.RESOURCE_LOCATION.fromJSON(json);

        if (registry.method_10250(id)) {
            return registry.method_10223(id);
        }

        throw new JsonParseException("ID '" + id + "' has not been registered");
    }

    @Override
    public JsonElement toJSON(T toWrite) {

        return Serializers.RESOURCE_LOCATION.toJSON(registry.method_10221(toWrite));
    }

    @Override
    public T fromByteBuf(class_2540 buffer) {

        final class_2960 id = Serializers.RESOURCE_LOCATION.fromByteBuf(buffer);
        return registry.method_10223(id);
    }

    @Override
    public void toByteBuf(class_2540 buffer, T toWrite) {

        Serializers.RESOURCE_LOCATION.toByteBuf(buffer, registry.method_10221(toWrite));
    }

    @Override
    public class_2520 toNBT(T toWrite) {

        return Serializers.RESOURCE_LOCATION.toNBT(registry.method_10221(toWrite));
    }

    @Override
    public T fromNBT(class_2520 nbt) {

        return registry.method_10223(Serializers.RESOURCE_LOCATION.fromNBT(nbt));
    }
}