package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import net.minecraft.class_2494;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public final class SerializerFloat implements ISerializer<Float> {

    public static final ISerializer<Float> SERIALIZER = new SerializerFloat();

    private SerializerFloat() {

    }

    @Override
    public Float fromJSON(JsonElement json) {

        return json.getAsFloat();
    }

    @Override
    public JsonElement toJSON(Float toWrite) {

        return new JsonPrimitive(toWrite);
    }

    @Override
    public Float fromByteBuf(class_2540 buffer) {

        return buffer.readFloat();
    }

    @Override
    public void toByteBuf(class_2540 buffer, Float toWrite) {

        buffer.writeFloat(toWrite);
    }

    @Override
    public class_2520 toNBT(Float toWrite) {

        return class_2494.method_23244(toWrite);
    }

    @Override
    public Float fromNBT(class_2520 nbt) {

        if (nbt instanceof class_2514 floatTag) {

            return floatTag.method_10700();
        }

        throw new NBTParseException("Expected NBT to be a number tag. Class was " + nbt.getClass() + " with ID " + nbt.method_10711() + " instead.");
    }
}