package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.darkhax.bookshelf.mixin.accessors.effect.AccessorMobEffectInstance;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import java.util.Optional;

public class SerializerEffectInstance implements ISerializer<class_1293> {

    @Override
    public class_1293 fromJSON(JsonElement json) {

        if (json instanceof JsonObject obj) {

            final class_1291 effect = Serializers.MOB_EFFECT.fromJSON(obj, "effect");
            final int duration = Serializers.INT.fromJSON(obj, "duration");
            final int amplifier = Serializers.INT.fromJSON(obj, "amplifier", 0);
            final boolean ambient = Serializers.BOOLEAN.fromJSON(obj, "ambient", false);
            final boolean visible = Serializers.BOOLEAN.fromJSON(obj, "visible", true);
            final boolean showIcon = Serializers.BOOLEAN.fromJSON(obj, "showIcon", true);
            final class_1293 hiddenEffect = Serializers.EFFECT_INSTANCE.fromJSON(obj, "hiddenEffect", (class_1293) null);

            // TODO Add serializer support for FactorData.
            return new class_1293(effect, duration, amplifier, ambient, visible, showIcon, hiddenEffect, effect.method_42127());
        }

        throw new JsonParseException("Expected JSON object.");
    }

    @Override
    public JsonElement toJSON(class_1293 toWrite) {

        final JsonObject json = new JsonObject();
        Serializers.MOB_EFFECT.toJSON(json, "effect", toWrite.method_5579());
        Serializers.INT.toJSON(json, "duration", toWrite.method_5584());

        if (toWrite.method_5578() != 0) {
            Serializers.INT.toJSON(json, "amplifier", toWrite.method_5578());
        }

        if (toWrite.method_5591()) {
            Serializers.BOOLEAN.toJSON(json, "ambient", toWrite.method_5591());
        }

        if (!toWrite.method_5581()) {
            Serializers.BOOLEAN.toJSON(json, "visible", toWrite.method_5581());
        }

        if (!toWrite.method_5592()) {
            Serializers.BOOLEAN.toJSON(json, "showIcon", toWrite.method_5592());
        }

        if (((AccessorMobEffectInstance) toWrite).bookshelf$getHiddenEffect() != null) {
            Serializers.EFFECT_INSTANCE.toJSON(json, "hiddenEffect", ((AccessorMobEffectInstance) toWrite).bookshelf$getHiddenEffect());
        }

        return json;
    }

    @Override
    public class_1293 fromByteBuf(class_2540 buffer) {

        final class_1291 effect = Serializers.MOB_EFFECT.fromByteBuf(buffer);
        final int duration = Serializers.INT.fromByteBuf(buffer);
        final int amplifier = Serializers.INT.fromByteBuf(buffer);
        final boolean ambient = Serializers.BOOLEAN.fromByteBuf(buffer);
        final boolean visible = Serializers.BOOLEAN.fromByteBuf(buffer);
        final boolean showIcon = Serializers.BOOLEAN.fromByteBuf(buffer);
        final class_1293 hiddenEffect = Serializers.EFFECT_INSTANCE.fromByteBufOptional(buffer).orElse(null);

        // TODO add factor data support.
        return new class_1293(effect, duration, amplifier, ambient, visible, showIcon, hiddenEffect, effect.method_42127());
    }

    @Override
    public void toByteBuf(class_2540 buffer, class_1293 toWrite) {

        Serializers.MOB_EFFECT.toByteBuf(buffer, toWrite.method_5579());
        Serializers.INT.toByteBuf(buffer, toWrite.method_5584());
        Serializers.INT.toByteBuf(buffer, toWrite.method_5578());
        Serializers.BOOLEAN.toByteBuf(buffer, toWrite.method_5591());
        Serializers.BOOLEAN.toByteBuf(buffer, toWrite.method_5581());
        Serializers.BOOLEAN.toByteBuf(buffer, toWrite.method_5592());
        Serializers.EFFECT_INSTANCE.toByteBufOptional(buffer, Optional.ofNullable(((AccessorMobEffectInstance) toWrite).bookshelf$getHiddenEffect()));
    }

    @Override
    public class_2520 toNBT(class_1293 toWrite) {

        final class_2487 tag = new class_2487();
        Serializers.MOB_EFFECT.toNBT(tag, "effect", toWrite.method_5579());
        Serializers.INT.toNBT(tag, "duration", toWrite.method_5584());

        if (toWrite.method_5578() != 0) {
            Serializers.INT.toNBT(tag, "amplifier", toWrite.method_5578());
        }

        if (toWrite.method_5591()) {
            Serializers.BOOLEAN.toNBT(tag, "ambient", toWrite.method_5591());
        }

        if (!toWrite.method_5581()) {
            Serializers.BOOLEAN.toNBT(tag, "visible", toWrite.method_5581());
        }

        if (!toWrite.method_5592()) {
            Serializers.BOOLEAN.toNBT(tag, "showIcon", toWrite.method_5592());
        }

        if (((AccessorMobEffectInstance) toWrite).bookshelf$getHiddenEffect() != null) {
            Serializers.EFFECT_INSTANCE.toNBT(tag, "hiddenEffect", ((AccessorMobEffectInstance) toWrite).bookshelf$getHiddenEffect());
        }
        return tag;
    }

    @Override
    public class_1293 fromNBT(class_2520 nbt) {

        final class_2487 tag = Serializers.COMPOUND_TAG.fromNBT(nbt);

        final class_1291 effect = Serializers.MOB_EFFECT.fromNBT(tag, "effect");
        final int duration = Serializers.INT.fromNBT(tag, "duration");
        final int amplifier = Serializers.INT.fromNBT(tag, "amplifier", 0);
        final boolean ambient = Serializers.BOOLEAN.fromNBT(tag, "ambient", false);
        final boolean visible = Serializers.BOOLEAN.fromNBT(tag, "visible", true);
        final boolean showIcon = Serializers.BOOLEAN.fromNBT(tag, "showIcon", true);
        final class_1293 hiddenEffect = Serializers.EFFECT_INSTANCE.fromNBT(tag, "hiddenEffect", null);

        // TODO add factor data.
        return new class_1293(effect, duration, amplifier, ambient, visible, showIcon, hiddenEffect, effect.method_42127());
    }
}
