package net.darkhax.bookshelf.api.serialization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2540;
import net.minecraft.class_3518;

public class SerializerCompoundTag implements ISerializer<class_2487> {

    public static final ISerializer<class_2487> SERIALIZER = new SerializerCompoundTag();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    private SerializerCompoundTag() {

    }

    @Override
    public class_2487 fromJSON(JsonElement json) {

        try {

            if (json.isJsonObject()) {

                // Some numbers like shorts and array tags like IntArrayNBT can not be
                // deserialized from objects due to NBT spec being dumb.
                return class_2522.method_10718(GSON.toJson(json));
            }
            else {

                return class_2522.method_10718(class_3518.method_15287(json, "nbt"));
            }
        }
        catch (final CommandSyntaxException e) {

            throw new JsonParseException("Failed to read NBT from " + class_3518.method_15266(json), e);
        }
    }

    @Override
    public JsonElement toJSON(class_2487 toWrite) {

        // While object is supported, some objects can never be deserialized properly.
        return new JsonPrimitive(toWrite.toString());
    }

    @Override
    public class_2487 fromByteBuf(class_2540 buffer) {

        return buffer.method_10798();
    }

    @Override
    public void toByteBuf(class_2540 buffer, class_2487 toWrite) {

        buffer.method_10794(toWrite);
    }

    @Override
    public class_2520 toNBT(class_2487 toWrite) {

        return toWrite;
    }

    @Override
    public class_2487 fromNBT(class_2520 nbt) {

        if (nbt instanceof class_2487 compound) {

            return compound;
        }

        throw new NBTParseException("Expected NBT to be a compound tag. Class was " + nbt.getClass() + " with ID " + nbt.method_10711() + " instead.");
    }
}