package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import net.minecraft.class_2481;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public final class SerializerByte implements ISerializer<Byte> {

    public static final ISerializer<Byte> SERIALIZER = new SerializerByte();

    private SerializerByte() {

    }

    @Override
    public Byte fromJSON(JsonElement json) {

        return json.getAsByte();
    }

    @Override
    public JsonElement toJSON(Byte toWrite) {

        return new JsonPrimitive(toWrite);
    }

    @Override
    public Byte fromByteBuf(class_2540 buffer) {

        return buffer.readByte();
    }

    @Override
    public void toByteBuf(class_2540 buffer, Byte toWrite) {

        buffer.writeByte(toWrite);
    }

    @Override
    public class_2520 toNBT(Byte toWrite) {

        return class_2481.method_23233(toWrite);
    }

    @Override
    public Byte fromNBT(class_2520 nbt) {

        if (nbt instanceof class_2514 byteTag) {

            return byteTag.method_10698();
        }

        throw new NBTParseException("Expected NBT to be a number tag. Class was " + nbt.getClass() + " with ID " + nbt.method_10711() + " instead.");
    }
}