package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import net.darkhax.bookshelf.Constants;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import java.util.Map.Entry;
import java.util.Optional;

public class SerializerBlockState implements ISerializer<class_2680> {

    public static final ISerializer<class_2680> SERIALIZER = new SerializerBlockState();

    private SerializerBlockState() {

    }

    @Override
    public class_2680 fromJSON(JsonElement json) {

        if (json.isJsonObject()) {

            final JsonObject obj = json.getAsJsonObject();
            final class_2248 block = Serializers.BLOCK.fromJSON(obj, "block");

            class_2680 state = block.method_9564();

            if (obj.has("properties")) {

                final JsonElement properties = obj.get("properties");

                for (final Entry<String, JsonElement> property : properties.getAsJsonObject().entrySet()) {

                    state = this.readProperty(state, property.getKey(), property.getValue());
                }
            }

            return state;
        }

        else if (json instanceof JsonPrimitive primitive && primitive.isString()) {

            final class_2248 block = Serializers.BLOCK.fromJSON(json);

            if (block != null) {
                return block.method_9564();
            }

            else {
                throw new JsonParseException("Block ID is missing or invalid. '" + json.getAsString() + "'");
            }
        }

        else {

            throw new JsonParseException("Expected properties to be an object. Recieved " + class_3518.method_15266(json));
        }
    }

    @Override
    public JsonElement toJSON(class_2680 toWrite) {

        final JsonObject json = new JsonObject();
        json.add("block", Serializers.BLOCK.toJSON(toWrite.method_26204()));

        final JsonObject properties = new JsonObject();

        for (final class_2769 prop : toWrite.method_28501()) {

            if (prop instanceof class_2758 intProp) {

                properties.addProperty(prop.method_11899(), toWrite.method_11654(intProp));
            }
            else if (prop instanceof class_2746 boolProp) {

                properties.addProperty(prop.method_11899(), toWrite.method_11654(boolProp));
            }
            else {

                properties.addProperty(prop.method_11899(), prop.method_11901(toWrite.method_11654(prop)));
            }
        }

        json.add("properties", properties);
        return json;
    }

    @Override
    public class_2680 fromByteBuf(class_2540 buffer) {

        return class_2248.method_9531(buffer.readInt());
    }

    @Override
    public void toByteBuf(class_2540 buffer, class_2680 toWrite) {

        buffer.writeInt(class_2248.method_9507(toWrite));
    }

    private class_2680 readProperty(class_2680 state, String propName, JsonElement propValue) {

        final class_2769 blockProperty = state.method_26204().method_9595().method_11663(propName);

        if (blockProperty != null) {

            if (propValue.isJsonPrimitive()) {

                final String valueString = propValue.getAsString();
                final Optional<Comparable> parsedValue = blockProperty.method_11900(valueString);

                if (parsedValue.isPresent()) {

                    try {

                        return state.method_11657(blockProperty, parsedValue.get());
                    }

                    catch (final Exception e) {

                        Constants.LOG.error("Failed to update state for block {}. The mod that adds this block may have an issue.", class_7923.field_41175.method_10221(state.method_26204()));
                        Constants.LOG.trace("Failed to read blockstate from JSON property.", e);
                        throw e;
                    }
                }
                else {

                    throw new JsonSyntaxException("The property " + propName + " with value " + valueString + " coul not be parsed!");
                }
            }
            else {

                throw new JsonSyntaxException("Expected property value for " + propName + " to be primitive string. Got " + class_3518.method_15266(propValue));
            }
        }
        else {

            throw new JsonSyntaxException("The property " + propName + " is not valid for block " + class_7923.field_41175.method_10221(state.method_26204()));
        }
    }

    @Override
    public class_2520 toNBT(class_2680 toWrite) {

        return class_2512.method_10686(toWrite);
    }

    @Override
    public class_2680 fromNBT(class_2520 nbt) {

        if (nbt instanceof class_2487 compound) {

            return class_2512.method_10681(class_7923.field_41175.method_46771(), compound);
        }

        throw new NBTParseException("Expected NBT to be a compound tag. Class was " + nbt.getClass() + " with ID " + nbt.method_10711() + " instead.");
    }
}