package net.darkhax.bookshelf.api.registry;

import net.darkhax.bookshelf.api.block.IItemBlockProvider;
import net.darkhax.bookshelf.api.commands.ICommandBuilder;
import net.darkhax.bookshelf.api.item.tab.ITabBuilder;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1535;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1865;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2396;
import net.minecraft.class_2582;
import net.minecraft.class_2591;
import net.minecraft.class_3302;
import net.minecraft.class_3414;
import net.minecraft.class_3448;
import net.minecraft.class_3611;
import net.minecraft.class_3852;
import net.minecraft.class_3917;
import net.minecraft.class_7924;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class RegistryDataProvider {

    private final String ownerId;

    public final IOwnedRegistryEntries<class_2248> blocks = new RegistryEntries<>(this::getOwner, class_7924.field_41254);
    public final IOwnedRegistryEntries<class_3611> fluids = new RegistryEntries<>(this::getOwner, class_7924.field_41270);
    public final IOwnedRegistryEntries<class_1792> items = new RegistryEntries<>(this::getOwner, class_7924.field_41197);
    public final IOwnedRegistryEntries<class_2582> bannerPatterns = new RegistryEntries<>(this::getOwner, class_7924.field_41252);
    public final IOwnedRegistryEntries<class_1291> mobEffects = new RegistryEntries<>(this::getOwner, class_7924.field_41208);
    public final IOwnedRegistryEntries<class_3414> sounds = new RegistryEntries<>(this::getOwner, class_7924.field_41225);
    public final IOwnedRegistryEntries<class_1842> potions = new RegistryEntries<>(this::getOwner, class_7924.field_41215);
    public final IOwnedRegistryEntries<class_1887> enchantments = new RegistryEntries<>(this::getOwner, class_7924.field_41265);
    public final IOwnedRegistryEntries<class_1299<?>> entities = new RegistryEntries<>(this::getOwner, class_7924.field_41266);
    public final IOwnedRegistryEntries<class_2591<?>> blockEntities = new RegistryEntries<>(this::getOwner, class_7924.field_41255);
    public final IOwnedRegistryEntries<class_2396<?>> particleTypes = new RegistryEntries<>(this::getOwner, class_7924.field_41210);
    public final IOwnedRegistryEntries<class_3917<?>> menus = new RegistryEntries<>(this::getOwner, class_7924.field_41207);
    public final IOwnedRegistryEntries<class_1865<?>> recipeSerializers = new RegistryEntries<>(this::getOwner, class_7924.field_41216);
    public final IOwnedRegistryEntries<class_1535> paintings = new RegistryEntries<>(this::getOwner, class_7924.field_41209);
    public final IOwnedRegistryEntries<class_1320> attributes = new RegistryEntries<>(this::getOwner, class_7924.field_41251);
    public final IOwnedRegistryEntries<class_3448<?>> stats = new RegistryEntries<>(this::getOwner, class_7924.field_41226);
    public final IOwnedRegistryEntries<class_3852> villagerProfessions = new RegistryEntries<>(this::getOwner, class_7924.field_41234);
    public final CommandArgumentRegistryEntries commandArguments = new CommandArgumentRegistryEntries(this::getOwner, class_7924.field_41262);
    public final RecipeTypeEntries recipeTypes = new RecipeTypeEntries(this::getOwner);
    public final IOwnedRegistryEntries<ICommandBuilder> commands = new RegistryEntries<>(this::getOwner, "Command");
    public final VillagerTradeEntries trades = new VillagerTradeEntries();
    public final IOwnedRegistryEntries<class_3302> resourceListeners = new RegistryEntries<>(this::getOwner, "Resource Listener");
    public final IOwnedRegistryEntries<class_3302> dataListeners = new RegistryEntries<>(this::getOwner, "Data Listener");
    public final IOwnedRegistryEntries<Consumer<ITabBuilder>> creativeTabs = new RegistryEntries<>(this::getOwner, "Creative Tabs");

    public RegistryDataProvider(String ownerId) {

        this.ownerId = ownerId;
    }

    public final RegistryDataProvider withItemTab(Supplier<class_1799> icon) {

        this.creativeTabs.add(() -> builder -> {
            builder.icon(icon);
            builder.displayItems((flags, output) -> output.acceptItemIter(this.items));
        }, "creative_tab");
        return this;
    }

    public final RegistryDataProvider withAutoItemBlocks() {

        // This code is invoked once for each block as it is being registered. At this stage
        // the actual block instance has been resolved.
        this.blocks.addRegistryListener((id, block) -> {

            // Allow blocks to specify custom itemblock behaviour
            if (block instanceof IItemBlockProvider provider) {

                // Returning false here will prevent an ItemBlock from being created.
                if (provider.hasItemBlock(block)) {

                    this.items.add(() -> provider.createItemBlock(block), id);
                }
            }

            // The default behaviour just makes a normal ItemBlock.
            else {

                this.items.add(() -> IItemBlockProvider.DEFAULT.createItemBlock(block), id);
            }
        });

        return this;
    }

    public String getOwner() {

        return this.ownerId;
    }
}
