package net.darkhax.bookshelf.api.registry;

import javax.annotation.Nullable;
import net.minecraft.class_2960;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface IRegistryEntries<V> extends Iterable<V> {

    <VT extends V> IRegistryObject<VT> add(Supplier<VT> value, class_2960 id);

    Map<class_2960, V> getEntries();

    boolean isEmpty();

    void addInsertListener(BiConsumer<class_2960, IRegistryObject<? extends V>> listener);

    void addRegistryListener(BiConsumer<class_2960, V> listener);

    void addRegistryWrapper(BiFunction<class_2960, V, V> wrapperFunc);

    void build(BiConsumer<class_2960, V> registerFunc);

    @Nullable
    default V getEntry(class_2960 id) {

        return this.getEntries().get(id);
    }

    @Nullable
    default V getOrDefault(class_2960 key, V fallback) {

        return getOrDefault(key, () -> fallback);
    }

    @Nullable
    default V getOrDefault(class_2960 key, Supplier<V> fallback) {

        V value;
        return (((value = this.getEntries().get(key)) != null) || this.getEntries().containsKey(key)) ? value : fallback.get();
    }

    default void ifPresent(class_2960 key, BiConsumer<class_2960, V> consumer) {

        final V value = this.getEntries().get(key);

        if (value != null || this.getEntries().containsKey(key)) {

            consumer.accept(key, value);
        }
    }

    default void ifAbsent(class_2960 key, Consumer<class_2960> consumer) {

        if (!this.getEntries().containsKey(key)) {

            consumer.accept(key);
        }
    }
}