package net.darkhax.bookshelf.api.item.tab;

import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;

public interface IOutputWrapper {

    void accept(class_1799 stack);

    void accept(class_1935 item);

    default void accept(Supplier<class_1792> item) {

        accept(item.get());
    }

    default void acceptStacks(Collection<class_1799> stacks) {

        stacks.forEach(this::accept);
    }

    default void acceptItems(Collection<class_1935> items) {

        items.forEach(this::accept);
    }

    default void acceptItemIter(Iterable<class_1792> items) {

        items.forEach(this::accept);
    }

    default void acceptItemSuppliers(Collection<Supplier<class_1792>> items) {

        items.forEach(this::accept);
    }
}
