package net.darkhax.bookshelf.api.enchantment;

import java.util.function.BiConsumer;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_1886;
import net.minecraft.class_1887;

public class BaseEnchantment extends class_1887 {

    private final class_1304[] slots;

    public BaseEnchantment(class_1888 rarity, class_1886 category, class_1304... slots) {

        super(rarity, category, slots);
        this.slots = slots;
    }

    /**
     * Allows the enchantment to apply attribute modifiers to an enchanted item. This may be called many times with
     * different item/slot combinations, especially in cases like tooltips. In most cases you should override
     * {@link #applyModifiers(int, BiConsumer)} instead, as it has boilerplate checks for the correct slot type built
     * in.
     *
     * @param stack The enchanted ItemStack.
     * @param level The level of the enchantment. This will always be at least 1.
     * @param slot  The slot being tested. This is not necessarily the slot the item is currently in, for example
     *              tooltips will test all slots.
     * @param adder A function to add your new modifiers.
     */
    public void applyModifiers(class_1799 stack, int level, class_1304 slot, BiConsumer<class_1320, class_1322> adder) {

        if (isValidSlot(slot) && class_1309.method_32326(stack) == slot) {
            this.applyModifiers(level, adder);
        }
    }

    /**
     * Allows the enchantment to apply attribute modifiers to an enchanted item. This will only be applied if the item
     * is in a valid slot for this type of enchantment.
     *
     * @param level The level of the enchantment. This will always be at least 1.
     * @param adder A function to add your new modifiers.
     */
    public void applyModifiers(int level, BiConsumer<class_1320, class_1322> adder) {

        // No default operation. Override to add your own!
    }

    public boolean isValidSlot(class_1304 slot) {

        for (final class_1304 validSlot : this.slots) {

            if (validSlot == slot) {

                return true;
            }
        }

        return false;
    }
}
