package net.darkhax.bookshelf.api.data.recipes;

import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5455;

/**
 * A partial implementation of {@link net.minecraft.class_1860} that is intended for recipes that are
 * not crafted through an inventory or traditional crafting system. This implementation provides default behaviours to
 * ignore the vanilla crafting system.
 * <p>
 * This approach is often preferred over defining your own reload listener as it allows the data to be synced to the
 * client and maintains a load order that is beneficial for implementing support for mods like JEI and CraftTweaker.
 *
 * @param <C> The type of inventory used to craft the recipe. This can usually be ignored.
 */
public abstract class RecipeBaseData<C extends class_1263> extends RecipeBase<C> {

    public RecipeBaseData(class_2960 id) {

        super(id);
    }

    @Override
    public boolean method_8115(C inventory, class_1937 level) {

        // This is not used by default.
        return false;
    }

    @Override
    public class_1799 method_8116(C c, class_5455 access) {

        // This is not used by default.
        return class_1799.field_8037;
    }

    @Override
    public boolean method_8113(int width, int height) {

        // This is not used by default.
        return false;
    }

    @Override
    public class_1799 method_8110(class_5455 access) {

        // This is not used by default.
        return class_1799.field_8037;
    }
}