package net.darkhax.bookshelf.api.data.recipes;

import net.minecraft.class_1263;
import net.minecraft.class_1860;
import net.minecraft.class_2960;

/**
 * A partial implementation of {@link class_1860} that provides the necessary ID handling and error detection.
 * <p>
 * Having a null {@link #method_8119()} or {@link #method_17716()} is considered invalid and will raise a {@link
 * IllegalStateException} if either are detected as null.
 *
 * @param <C> The type of inventory used to craft this recipe.
 */
public abstract class RecipeBase<C extends class_1263> implements class_1860<C> {

    /**
     * The namespace identifier for the recipe entry.
     */
    private final class_2960 id;

    public RecipeBase(class_2960 id) {

        this.id = id;

        if (this.method_8119() == null) {

            throw new IllegalStateException("Recipe class " + this.getClass().getName() + " can not be serialized.");
        }

        if (this.method_17716() == null) {

            throw new IllegalStateException("Recipe class " + this.getClass().getName() + " has no recipe type!");
        }
    }

    @Override
    public class_2960 method_8114() {

        return this.id;
    }
}