package net.darkhax.bookshelf.api.commands.args;

import com.google.gson.JsonObject;
import com.mojang.brigadier.arguments.ArgumentType;
import net.darkhax.bookshelf.api.function.CachedSupplier;
import net.minecraft.class_2314;
import net.minecraft.class_2540;
import net.minecraft.class_7157;
import java.util.function.Supplier;

public final class SingletonArgumentInfo<T extends ArgumentType<?>> implements class_2314<T, SingletonArgumentInfo.Template<T>> {

    public static <T extends ArgumentType<?>> SingletonArgumentInfo<T> of(T argSupplier) {

        return new SingletonArgumentInfo<>(() -> argSupplier);
    }

    public static <T extends ArgumentType<?>> SingletonArgumentInfo<T> of(Supplier<T> argSupplier) {

        return new SingletonArgumentInfo<>(argSupplier);
    }

    private final CachedSupplier<Template<T>> templateSupplier;

    private SingletonArgumentInfo(Supplier<T> singletonSupplier) {

        this.templateSupplier = CachedSupplier.cache(() -> new Template<>(singletonSupplier, this));
    }

    @Override
    public void serializeToNetwork(Template<T> tTemplate, class_2540 friendlyByteBuf) {

    }

    @Override
    public Template<T> method_10005(class_2540 buffer) {

        return this.templateSupplier.get();
    }

    @Override
    public void serializeToJson(Template<T> tTemplate, JsonObject jsonObject) {

    }
    
    @Override
    public Template<T> method_41726(T template) {

        return this.templateSupplier.get();
    }

    public static class Template<T extends ArgumentType<?>> implements class_2314.class_7217<T> {

        private final class_2314<T, ?> info;
        private final Supplier<T> singletonSupplier;

        public Template(Supplier<T> supplier, class_2314<T, ?> info) {

            this.singletonSupplier = supplier;
            this.info = info;
        }
        
        @Override
        public T method_41730(class_7157 ctx) {

            return this.singletonSupplier.get();
        }
        
        @Override
        public class_2314<T, ?> method_41728() {

            return this.info;
        }
    }
}