package net.darkhax.bookshelf.api.client;

import net.darkhax.bookshelf.api.Services;
import net.minecraft.class_1058;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3610;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.joml.Matrix4f;

public interface RenderHelper {

    RenderHelper INSTANCE = Services.load(RenderHelper.class);

    static RenderHelper get() {

        return INSTANCE;
    }

    void renderFluidBox(class_4587 pose, class_3610 fluidState, class_1937 level, class_2338 pos, class_4597 bufferSource, int light, int overlay);

    default int[] argb(int color) {

        final int[] colors = new int[4];
        colors[0] = color >> 24 & 0xff; // alpha
        colors[1] = color >> 16 & 0xff; // red
        colors[2] = color >> 8 & 0xff; // green
        colors[3] = color & 0xff; // blue
        return colors;
    }

    /**
     * Renders a box with the sprite on each face.
     *
     * @param builder The vertex consumer.
     * @param stack   The pose stack.
     * @param sprite  The sprite to render.
     * @param light   The packed light data.
     * @param overlay The overlay day.
     * @param color   Unpacked color data in ARGB ordering.
     */
    default void renderBox(class_4588 builder, class_4587 stack, class_1058 sprite, int light, int overlay, int[] color) {

        renderBox(builder, stack.method_23760().method_23761(), sprite, light, overlay, 0f, 1f, 0f, 1f, 0f, 1f, color);
    }

    /**
     * Renders a box with the sprite on each face.
     *
     * @param builder The vertex consumer.
     * @param stack   The post stack.
     * @param sprite  The sprite to render.
     * @param light   Packed light coordinates.
     * @param overlay Overlay data.
     * @param x1      The starting render position on the X axis.
     * @param x2      The ending render postion on the X axis.
     * @param y1      The starting render position on the Y axis.
     * @param y2      The ending render position on the Y axis.
     * @param z1      The starting render position on the Z axis.
     * @param z2      The ending render position on the Z axis.
     * @param color   Unpacked color data in ARGB ordering.
     */
    default void renderBox(class_4588 builder, class_4587 stack, class_1058 sprite, int light, int overlay, float x1, float x2, float y1, float y2, float z1, float z2, int[] color) {

        renderBox(builder, stack.method_23760().method_23761(), sprite, light, overlay, x1, x2, y1, y2, z1, z2, color);
    }

    /**
     * Renders a box with the sprite on each face.
     *
     * @param builder The vertex consumer.
     * @param pos     The position to render at.
     * @param sprite  The sprite to render.
     * @param light   Packed light coordinates.
     * @param overlay Overlay data.
     * @param x1      The starting render position on the X axis.
     * @param x2      The ending render postion on the X axis.
     * @param y1      The starting render position on the Y axis.
     * @param y2      The ending render position on the Y axis.
     * @param z1      The starting render position on the Z axis.
     * @param z2      The ending render position on the Z axis.
     * @param color   Unpacked color data in ARGB ordering.
     */
    default void renderBox(class_4588 builder, Matrix4f pos, class_1058 sprite, int light, int overlay, float x1, float x2, float y1, float y2, float z1, float z2, int[] color) {

        renderFace(builder, pos, sprite, class_2350.field_11033, light, overlay, x1, x2, y1, y2, z1, z2, color);
        renderFace(builder, pos, sprite, class_2350.field_11036, light, overlay, x1, x2, y1, y2, z1, z2, color);
        renderFace(builder, pos, sprite, class_2350.field_11043, light, overlay, x1, x2, y1, y2, z1, z2, color);
        renderFace(builder, pos, sprite, class_2350.field_11035, light, overlay, x1, x2, y1, y2, z1, z2, color);
        renderFace(builder, pos, sprite, class_2350.field_11039, light, overlay, x1, x2, y1, y2, z1, z2, color);
        renderFace(builder, pos, sprite, class_2350.field_11034, light, overlay, x1, x2, y1, y2, z1, z2, color);
    }

    /**
     * Renders the face of a box.
     *
     * @param builder The vertex consumer.
     * @param pos     The position to render at.
     * @param sprite  The sprite to render.
     * @param side    The side to render.
     * @param light   Packed light coordinates.
     * @param overlay Overlay data.
     * @param x1      The starting render position on the X axis.
     * @param x2      The ending render postion on the X axis.
     * @param y1      The starting render position on the Y axis.
     * @param y2      The ending render position on the Y axis.
     * @param z1      The starting render position on the Z axis.
     * @param z2      The ending render position on the Z axis.
     * @param color   Unpacked color data in ARGB ordering.
     */
    default void renderFace(class_4588 builder, Matrix4f pos, class_1058 sprite, class_2350 side, int light, int overlay, float x1, float x2, float y1, float y2, float z1, float z2, int[] color) {

        // Convert block size to pixel size
        final double px1 = x1 * 16;
        final double px2 = x2 * 16;
        final double py1 = y1 * 16;
        final double py2 = y2 * 16;
        final double pz1 = z1 * 16;
        final double pz2 = z2 * 16;

        switch (side) {

            case field_11033 -> {
                final float u1 = sprite.method_4580(px1);
                final float u2 = sprite.method_4580(px2);
                final float v1 = sprite.method_4570(pz1);
                final float v2 = sprite.method_4570(pz2);
                builder.method_22918(pos, x1, y1, z2).method_1336(color[1], color[2], color[3], color[0]).method_22913(u1, v2).method_22922(overlay).method_22916(light).method_22914(0f, -1f, 0f).method_1344();
                builder.method_22918(pos, x1, y1, z1).method_1336(color[1], color[2], color[3], color[0]).method_22913(u1, v1).method_22922(overlay).method_22916(light).method_22914(0f, -1f, 0f).method_1344();
                builder.method_22918(pos, x2, y1, z1).method_1336(color[1], color[2], color[3], color[0]).method_22913(u2, v1).method_22922(overlay).method_22916(light).method_22914(0f, -1f, 0f).method_1344();
                builder.method_22918(pos, x2, y1, z2).method_1336(color[1], color[2], color[3], color[0]).method_22913(u2, v2).method_22922(overlay).method_22916(light).method_22914(0f, -1f, 0f).method_1344();
            }
            case field_11036 -> {
                final float u1 = sprite.method_4580(px1);
                final float u2 = sprite.method_4580(px2);
                final float v1 = sprite.method_4570(pz1);
                final float v2 = sprite.method_4570(pz2);
                builder.method_22918(pos, x1, y2, z2).method_1336(color[1], color[2], color[3], color[0]).method_22913(u1, v2).method_22922(overlay).method_22916(light).method_22914(0f, 1f, 0f).method_1344();
                builder.method_22918(pos, x2, y2, z2).method_1336(color[1], color[2], color[3], color[0]).method_22913(u2, v2).method_22922(overlay).method_22916(light).method_22914(0f, 1f, 0f).method_1344();
                builder.method_22918(pos, x2, y2, z1).method_1336(color[1], color[2], color[3], color[0]).method_22913(u2, v1).method_22922(overlay).method_22916(light).method_22914(0f, 1f, 0f).method_1344();
                builder.method_22918(pos, x1, y2, z1).method_1336(color[1], color[2], color[3], color[0]).method_22913(u1, v1).method_22922(overlay).method_22916(light).method_22914(0f, 1f, 0f).method_1344();
            }
            case field_11043 -> {
                final float u1 = sprite.method_4580(px1);
                final float u2 = sprite.method_4580(px2);
                final float v1 = sprite.method_4570(py1);
                final float v2 = sprite.method_4570(py2);
                builder.method_22918(pos, x1, y1, z1).method_1336(color[1], color[2], color[3], color[0]).method_22913(u1, v1).method_22922(overlay).method_22916(light).method_22914(0f, 0f, -1f).method_1344();
                builder.method_22918(pos, x1, y2, z1).method_1336(color[1], color[2], color[3], color[0]).method_22913(u1, v2).method_22922(overlay).method_22916(light).method_22914(0f, 0f, -1f).method_1344();
                builder.method_22918(pos, x2, y2, z1).method_1336(color[1], color[2], color[3], color[0]).method_22913(u2, v2).method_22922(overlay).method_22916(light).method_22914(0f, 0f, -1f).method_1344();
                builder.method_22918(pos, x2, y1, z1).method_1336(color[1], color[2], color[3], color[0]).method_22913(u2, v1).method_22922(overlay).method_22916(light).method_22914(0f, 0f, -1f).method_1344();
            }
            case field_11035 -> {
                final float u1 = sprite.method_4580(px1);
                final float u2 = sprite.method_4580(px2);
                final float v1 = sprite.method_4570(py1);
                final float v2 = sprite.method_4570(py2);
                builder.method_22918(pos, x2, y1, z2).method_1336(color[1], color[2], color[3], color[0]).method_22913(u2, v1).method_22922(overlay).method_22916(light).method_22914(0f, 0f, 1f).method_1344();
                builder.method_22918(pos, x2, y2, z2).method_1336(color[1], color[2], color[3], color[0]).method_22913(u2, v2).method_22922(overlay).method_22916(light).method_22914(0f, 0f, 1f).method_1344();
                builder.method_22918(pos, x1, y2, z2).method_1336(color[1], color[2], color[3], color[0]).method_22913(u1, v2).method_22922(overlay).method_22916(light).method_22914(0f, 0f, 1f).method_1344();
                builder.method_22918(pos, x1, y1, z2).method_1336(color[1], color[2], color[3], color[0]).method_22913(u1, v1).method_22922(overlay).method_22916(light).method_22914(0f, 0f, 1f).method_1344();
            }
            case field_11039 -> {
                final float u1 = sprite.method_4580(py1);
                final float u2 = sprite.method_4580(py2);
                final float v1 = sprite.method_4570(pz1);
                final float v2 = sprite.method_4570(pz2);
                builder.method_22918(pos, x1, y1, z2).method_1336(color[1], color[2], color[3], color[0]).method_22913(u1, v2).method_22922(overlay).method_22916(light).method_22914(-1f, 0f, 0f).method_1344();
                builder.method_22918(pos, x1, y2, z2).method_1336(color[1], color[2], color[3], color[0]).method_22913(u2, v2).method_22922(overlay).method_22916(light).method_22914(-1f, 0f, 0f).method_1344();
                builder.method_22918(pos, x1, y2, z1).method_1336(color[1], color[2], color[3], color[0]).method_22913(u2, v1).method_22922(overlay).method_22916(light).method_22914(-1f, 0f, 0f).method_1344();
                builder.method_22918(pos, x1, y1, z1).method_1336(color[1], color[2], color[3], color[0]).method_22913(u1, v1).method_22922(overlay).method_22916(light).method_22914(-1f, 0f, 0f).method_1344();
            }
            case field_11034 -> {
                final float u1 = sprite.method_4580(py1);
                final float u2 = sprite.method_4580(py2);
                final float v1 = sprite.method_4570(pz1);
                final float v2 = sprite.method_4570(pz2);
                builder.method_22918(pos, x2, y1, z1).method_1336(color[1], color[2], color[3], color[0]).method_22913(u1, v1).method_22922(overlay).method_22916(light).method_22914(1f, 0f, 0f).method_1344();
                builder.method_22918(pos, x2, y2, z1).method_1336(color[1], color[2], color[3], color[0]).method_22913(u2, v1).method_22922(overlay).method_22916(light).method_22914(1f, 0f, 0f).method_1344();
                builder.method_22918(pos, x2, y2, z2).method_1336(color[1], color[2], color[3], color[0]).method_22913(u2, v2).method_22922(overlay).method_22916(light).method_22914(1f, 0f, 0f).method_1344();
                builder.method_22918(pos, x2, y1, z2).method_1336(color[1], color[2], color[3], color[0]).method_22913(u1, v2).method_22922(overlay).method_22916(light).method_22914(1f, 0f, 0f).method_1344();
            }
        }
    }
}