package net.darkhax.bookshelf.api.block.entity;

import net.darkhax.bookshelf.api.function.CachedSupplier;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import javax.annotation.Nullable;
import java.util.stream.IntStream;

/**
 * An implementation of InventoryBlockEntity that allows the inventory to be externally accessed by stuff like hoppers.
 *
 * @param <T> The type of inventory held by the BlockEntity.
 */
public abstract class WorldlyInventoryBlockEntity<T extends class_1263> extends InventoryBlockEntity<T> implements class_1278 {

    private final CachedSupplier<int[]> fallbackSlots = CachedSupplier.cache(() -> IntStream.range(0, method_5439()).toArray());

    public WorldlyInventoryBlockEntity(class_2591 type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public final int[] method_5494(class_2350 side) {

        if (this.getInventory() instanceof class_1278 worldy) {

            return worldy.method_5494(side);
        }

        return fallbackSlots.get();
    }

    @Override
    public final boolean method_5492(int slotId, class_1799 stack, @Nullable class_2350 side) {

        if (this.getInventory() instanceof class_1278 worldly) {

            return worldly.method_5492(slotId, stack, side);
        }

        return this.getInventory().method_5437(slotId, stack) && this.method_5438(slotId).method_7947() < this.method_5444();
    }

    @Override
    public final boolean method_5493(int slotId, class_1799 stack, class_2350 side) {

        if (this.getInventory() instanceof class_1278 worldly) {

            return worldly.method_5493(slotId, stack, side);
        }

        return true;
    }
}