/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.gametest;

import com.google.common.base.CaseFormat;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import net.darkhax.bookshelf.Constants;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.data.sound.Sound;
import net.darkhax.bookshelf.api.item.ItemStackBuilder;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.bookshelf.api.util.ItemStackHelper;
import net.darkhax.bookshelf.impl.gametest.ITestable;
import net.darkhax.bookshelf.impl.gametest.TestSerialization;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestGenerator;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BannerPatternTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.PaintingVariantTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.decoration.PaintingVariants;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class BookshelfGameTests {
    @GameTestGenerator
    public static Collection<TestFunction> generate() {
        ArrayList<TestFunction> testFunctions = new ArrayList<TestFunction>();
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Boolean>("boolean", Serializers.BOOLEAN, false, true, true, false));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Byte>("byte", Serializers.BYTE, (byte)1, (byte)32, (byte)44, (byte)0));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Short>("short", Serializers.SHORT, (short)800, (short)1337));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Integer>("int", Serializers.INT, 54, 23, Integer.MAX_VALUE, 234234, Integer.MIN_VALUE));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Long>("long", Serializers.LONG, 99L, 23441322L, Long.MIN_VALUE, 93015L, Long.MAX_VALUE));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Float>("float", Serializers.FLOAT, Float.valueOf(8.0f), Float.valueOf(-23.456f), Float.valueOf(789.01f), Float.valueOf(Float.MAX_VALUE), Float.valueOf(-11.0f), Float.valueOf(Float.MIN_VALUE)));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Double>("double", Serializers.DOUBLE, 24.92, Double.MAX_VALUE, -922321.12345, Double.MIN_VALUE));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<String>("string", Serializers.STRING, "one", "two", "3", "IV", ".....", "/I", "!@#$%^&*()_-"));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<UUID>("uuid", Serializers.UUID, UUID.randomUUID(), UUID.fromString("da0317d2-e550-11ec-8fea-0242ac120002"), UUID.randomUUID()));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<ResourceLocation>("resource_location", Serializers.RESOURCE_LOCATION, new ResourceLocation("hello_world"), new ResourceLocation("test", "two"), new ResourceLocation("test_from", "stuff/things/okay_stuff")));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<ItemStack>("item_stack", Serializers.ITEM_STACK, ItemStackHelper::areStacksEquivalent, (T[])BookshelfGameTests.getTestStacks()));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<CompoundTag>("nbt_compound_tag", Serializers.COMPOUND_TAG, BookshelfGameTests.getTestTags()));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Component>("text_component", Serializers.TEXT, Component.translatable((String)"moon.phase.full").withStyle(ChatFormatting.DARK_AQUA), Component.literal((String)"Hello World"), Component.literal((String)"okay").withStyle(s -> s.withFont(new ResourceLocation("minecraft:alt")))));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<BlockPos>("block_pos", Serializers.BLOCK_POS, new BlockPos(1, 2, 3), new BlockPos(0, 0, 0), BlockPos.of((long)123456L)));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Ingredient>("ingredient", Serializers.INGREDIENT, BookshelfGameTests::assertEqual, (T[])new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.STONE_AXE}), Ingredient.EMPTY, Ingredient.of((ItemLike[])new ItemLike[]{Items.COAL}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.ACACIA_BOAT)}), Ingredient.of((TagKey)ItemTags.BEDS)}));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<BlockState>("block_state", Serializers.BLOCK_STATE, Blocks.STONE.defaultBlockState(), Blocks.CHEST.defaultBlockState(), (BlockState)Blocks.ACACIA_PRESSURE_PLATE.defaultBlockState().setValue((Property)PressurePlateBlock.POWERED, (Comparable)Boolean.valueOf(true))));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<AttributeModifier>("attribute_modifier", Serializers.ATTRIBUTE_MODIFIER, new AttributeModifier("test", 15.0, AttributeModifier.Operation.MULTIPLY_BASE), new AttributeModifier(UUID.randomUUID(), "test_2", 9.55, AttributeModifier.Operation.ADDITION), new AttributeModifier("test3", 35.0, AttributeModifier.Operation.MULTIPLY_TOTAL)));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<MobEffectInstance>("effect_instance", Serializers.EFFECT_INSTANCE, new MobEffectInstance(MobEffects.ABSORPTION, 100, 10), new MobEffectInstance(MobEffects.BAD_OMEN, 10)));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<EnchantmentInstance>("enchantment_instance", Serializers.ENCHANTMENT_INSTANCE, BookshelfGameTests::assertEncantmentInstanceEqual, (T[])new EnchantmentInstance[]{new EnchantmentInstance(Enchantments.ALL_DAMAGE_PROTECTION, 5), new EnchantmentInstance(Enchantments.BINDING_CURSE, 15), new EnchantmentInstance(Enchantments.IMPALING, 2)}));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Vector3f>("Vector3f", Serializers.VECTOR_3F, new Vector3f(1.0f, 2.0f, 3.0f), new Vector3f(-5.0f, -2.0f, 44.0f), new Vector3f(Float.MAX_VALUE, Float.MIN_VALUE, Float.MIN_VALUE)));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Vector4f>("Vector4f", Serializers.VECTOR_4F, new Vector4f(1.0f, 2.0f, 3.0f, 4.0f), new Vector4f(0.0f, -22.0f, -2222.0f, 0.0f), new Vector4f(Float.MAX_VALUE, Float.MIN_VALUE, Float.MIN_VALUE, Float.MAX_VALUE)));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Sound>("sound", Serializers.SOUND, new Sound(SoundEvents.DOLPHIN_JUMP, SoundSource.AMBIENT, 1.0f, 1.0f), new Sound(SoundEvents.ALLAY_HURT, SoundSource.NEUTRAL, 0.5f, 0.222f), new Sound(SoundEvents.SQUID_AMBIENT, SoundSource.PLAYERS, 0.1f, 0.2f)));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Rarity>("item_rarity", Serializers.ITEM_RARITY, Rarity.COMMON, Rarity.EPIC, Rarity.RARE, Rarity.RARE));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Enchantment.Rarity>("enchantment_rarity", Serializers.ENCHANTMENT_RARITY, Enchantment.Rarity.COMMON, Enchantment.Rarity.COMMON, Enchantment.Rarity.RARE, Enchantment.Rarity.UNCOMMON));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<AttributeModifier.Operation>("attribute_modifier", Serializers.ATTRIBUTE_OPERATION, AttributeModifier.Operation.ADDITION, AttributeModifier.Operation.ADDITION, AttributeModifier.Operation.MULTIPLY_BASE, AttributeModifier.Operation.MULTIPLY_TOTAL, AttributeModifier.Operation.MULTIPLY_TOTAL));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Direction>("direction", Serializers.DIRECTION, Direction.UP, Direction.UP, Direction.DOWN, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.SOUTH));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Direction.Axis>("axis", Serializers.AXIS, Direction.Axis.X, Direction.Axis.X, Direction.Axis.Y, Direction.Axis.Z, Direction.Axis.Y));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Direction.Plane>("plane", Serializers.PLANE, Direction.Plane.HORIZONTAL, Direction.Plane.VERTICAL, Direction.Plane.VERTICAL, Direction.Plane.VERTICAL, Direction.Plane.HORIZONTAL));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<MobCategory>("mob_category", Serializers.MOB_CATEGORY, MobCategory.AMBIENT, MobCategory.AXOLOTLS, MobCategory.CREATURE, MobCategory.AXOLOTLS, MobCategory.MONSTER, MobCategory.MISC));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<EnchantmentCategory>("enchantment_category", Serializers.ENCHANTMENT_CATEGORY, EnchantmentCategory.ARMOR, EnchantmentCategory.BREAKABLE, EnchantmentCategory.BREAKABLE));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<DyeColor>("dye_color", Serializers.DYE_COLOR, DyeColor.BLACK, DyeColor.RED, DyeColor.BLUE));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<SoundSource>("sound_category", Serializers.SOUND_CATEGORY, SoundSource.AMBIENT, SoundSource.HOSTILE, SoundSource.PLAYERS));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Block>("registry_block", Serializers.BLOCK, Blocks.SAND, Blocks.STONE, Blocks.KELP, Blocks.SAND));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Item>("registry_item", Serializers.ITEM, Items.APPLE, Items.STICK, Items.STICK, Items.COOKED_PORKCHOP));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Enchantment>("registry_enchantment", Serializers.ENCHANTMENT, Enchantments.ALL_DAMAGE_PROTECTION, Enchantments.BLAST_PROTECTION, Enchantments.BLAST_PROTECTION, Enchantments.SILK_TOUCH));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<PaintingVariant>("registry_painting", Serializers.PAINTING, (PaintingVariant)BuiltInRegistries.PAINTING_VARIANT.get(PaintingVariants.COURBET.location()), (PaintingVariant)BuiltInRegistries.PAINTING_VARIANT.get(PaintingVariants.AZTEC.location())));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Potion>("registry_potion", Serializers.POTION, Potions.EMPTY, Potions.AWKWARD, Potions.AWKWARD, Potions.FIRE_RESISTANCE, Potions.HEALING));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<Attribute>("registry_attribute", Serializers.ATTRIBUTE, Attributes.ARMOR, Attributes.ATTACK_SPEED, Attributes.MAX_HEALTH, Attributes.SPAWN_REINFORCEMENTS_CHANCE));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<VillagerProfession>("registry_villager_profession", Serializers.VILLAGER_PROFESSION, VillagerProfession.ARMORER, VillagerProfession.ARMORER, VillagerProfession.BUTCHER, VillagerProfession.LEATHERWORKER, VillagerProfession.WEAPONSMITH));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<VillagerType>("registry_villager_type", Serializers.VILLAGER_TYPE, VillagerType.SWAMP, VillagerType.JUNGLE, VillagerType.JUNGLE, VillagerType.PLAINS));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<SoundEvent>("registry_sound_event", Serializers.SOUND_EVENT, SoundEvents.ANVIL_STEP, SoundEvents.BAMBOO_STEP, SoundEvents.AXE_STRIP, SoundEvents.DOLPHIN_JUMP));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<MenuType>("registry_menu", Serializers.MENU, MenuType.ANVIL, MenuType.GENERIC_9x2, MenuType.ENCHANTMENT, MenuType.CARTOGRAPHY_TABLE));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<ParticleType>("registry_particle_type", Serializers.PARTICLE, ParticleTypes.BUBBLE_POP, ParticleTypes.BUBBLE_COLUMN_UP, ParticleTypes.CLOUD, ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, ParticleTypes.DRIPPING_OBSIDIAN_TEAR));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<EntityType>("registry_entity_type", Serializers.ENTITY, EntityType.BAT, EntityType.ARROW, EntityType.AXOLOTL, EntityType.DRAGON_FIREBALL));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<BlockEntityType>("registry_block_entity_type", Serializers.BLOCK_ENTITY, BlockEntityType.BARREL, BlockEntityType.BEACON, BlockEntityType.BEEHIVE, BlockEntityType.JUKEBOX));
        BookshelfGameTests.testFrom(testFunctions, new TestSerialization<GameEvent>("registry_game_event", Serializers.GAME_EVENT, GameEvent.FLAP, GameEvent.FLUID_PICKUP, GameEvent.PRIME_FUSE, GameEvent.LIGHTNING_STRIKE));
        ResourceLocation tagOne = new ResourceLocation("test", "one");
        ResourceLocation tagTwo = new ResourceLocation("test", "two");
        BookshelfGameTests.testFromTags(testFunctions, "block_tag", Serializers.BLOCK_TAG, BlockTags.ANVIL, BlockTags.BEDS, BlockTags.BASE_STONE_NETHER);
        BookshelfGameTests.testFromTags(testFunctions, "item_tag", Serializers.ITEM_TAG, ItemTags.ANVIL, ItemTags.AXOLOTL_TEMPT_ITEMS, ItemTags.BIRCH_LOGS);
        BookshelfGameTests.testFromTags(testFunctions, "banner_pattern_tag", Serializers.BANNER_PATTERN_TAG, BannerPatternTags.NO_ITEM_REQUIRED, BannerPatternTags.PATTERN_ITEM_GLOBE, BannerPatternTags.PATTERN_ITEM_CREEPER);
        BookshelfGameTests.testFromTags(testFunctions, "enchantment_tag", Serializers.ENCHANTMENT_TAG, Services.TAGS.enchantmentTag(tagOne), Services.TAGS.enchantmentTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "painting_tag", Serializers.MOTIVE_TAG, PaintingVariantTags.PLACEABLE, PaintingVariantTags.PLACEABLE);
        BookshelfGameTests.testFromTags(testFunctions, "mob_effect_tag", Serializers.MOB_EFFECT_TAG, Services.TAGS.effectTag(tagOne), Services.TAGS.effectTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "potion_tag", Serializers.POTION_TAG, Services.TAGS.potionTag(tagOne), Services.TAGS.potionTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "attribute_tag", Serializers.ATTRIBUTE_TAG, Services.TAGS.attributeTag(tagOne), Services.TAGS.attributeTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "villager_profession_tag", Serializers.VILLAGER_PROFESSION_TAG, Services.TAGS.villagerProfessionTag(tagOne), Services.TAGS.villagerProfessionTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "villager_type_tag", Serializers.VILLAGER_TYPE_TAG, Services.TAGS.villagerTypeTag(tagOne), Services.TAGS.villagerTypeTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "sound_event_tag", Serializers.SOUND_EVENT_TAG, Services.TAGS.soundTag(tagOne), Services.TAGS.soundTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "menu_tag", Serializers.MENU_TAG, Services.TAGS.menuTag(tagOne), Services.TAGS.menuTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "particle_type_tag", Serializers.PARTICLE_TAG, Services.TAGS.particleTag(tagOne), Services.TAGS.particleTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "entity_type_tag", Serializers.ENTITY_TAG, EntityTypeTags.ARROWS, EntityTypeTags.AXOLOTL_ALWAYS_HOSTILES, EntityTypeTags.POWDER_SNOW_WALKABLE_MOBS);
        BookshelfGameTests.testFromTags(testFunctions, "block_entity_type_tag", Serializers.BLOCK_ENTITY_TAG, Services.TAGS.blockEntityTag(tagOne), Services.TAGS.blockEntityTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "game_event_tag", Serializers.GAME_EVENT_TAG, GameEventTags.IGNORE_VIBRATIONS_SNEAKING, GameEventTags.VIBRATIONS, GameEventTags.VIBRATIONS);
        BookshelfGameTests.testFromTags(testFunctions, "fluid_tag", Serializers.FLUID_TAG, FluidTags.LAVA, FluidTags.WATER);
        BookshelfGameTests.testFromTags(testFunctions, "stat_tag", Serializers.STAT_TAG, Services.TAGS.statTag(tagOne), Services.TAGS.statTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "recipe_type_tag", Serializers.RECIPE_TYPE_TAG, Services.TAGS.recipeTypeTag(tagOne), Services.TAGS.recipeTypeTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "recipe_serializer_tag", Serializers.RECIPE_SERIALIZER_TAG, Services.TAGS.recipeSerializerTag(tagOne), Services.TAGS.recipeSerializerTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "dimension_type_tag", Serializers.DIMENSION_TYPE_TAG, Services.TAGS.dimensionTypeTag(tagOne), Services.TAGS.dimensionTypeTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "dimension_tag", Serializers.DIMENSION_TAG, Services.TAGS.dimensionTag(tagOne), Services.TAGS.dimensionTag(tagTwo));
        BookshelfGameTests.testFromTags(testFunctions, "biome_tag", Serializers.BIOME_TAG, Services.TAGS.biomeTag(tagOne), Services.TAGS.biomeTag(tagTwo));
        return testFunctions;
    }

    public static <T> void testFrom(Collection<TestFunction> functions, T testImpl) {
        String string;
        if (testImpl instanceof ITestable) {
            ITestable testObj = (ITestable)testImpl;
            string = testObj.getDefaultBatch();
        } else {
            string = null;
        }
        String parentBatch = string;
        for (Method method : testImpl.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(GameTest.class)) continue;
            GameTest annotation = method.getAnnotation(GameTest.class);
            String template = annotation.template().isEmpty() ? "bookshelf:empty" : annotation.template();
            String batch = parentBatch != null && annotation.batch().equalsIgnoreCase("defaultBatch") ? parentBatch : annotation.batch();
            String testName = batch + "." + CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, method.getName());
            Rotation rotation = StructureUtils.getRotationForRotationSteps((int)annotation.rotationSteps());
            functions.add(new TestFunction(batch, testName, template, rotation, annotation.timeoutTicks(), annotation.setupTicks(), annotation.required(), annotation.requiredSuccesses(), annotation.attempts(), gameTestHelper -> {
                try {
                    method.invoke(testImpl, gameTestHelper);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Failed to invoke test method (%s) in (%s) because %s".formatted(method.getName(), method.getDeclaringClass().getCanonicalName(), e.getMessage()), e);
                }
                catch (InvocationTargetException e) {
                    RuntimeException runtimeException;
                    Throwable throwable = e.getCause();
                    RuntimeException rte = throwable instanceof RuntimeException ? (runtimeException = (RuntimeException)throwable) : new RuntimeException(e.getCause());
                    Constants.LOG.error("The test {} failed to run!", (Object)testName, (Object)e);
                    throw rte;
                }
            }));
        }
    }

    private static <T> void testFromTags(Collection<TestFunction> functions, String name, ISerializer<TagKey<T>> serializer, TagKey<T> ... tags) {
        BookshelfGameTests.testFrom(functions, new TestSerialization<TagKey<T>>(name, serializer, BookshelfGameTests::assertTagEqual, (T[])tags));
    }

    private static boolean assertEncantmentInstanceEqual(EnchantmentInstance a, EnchantmentInstance b) {
        if (Objects.equals(a, b)) {
            return true;
        }
        if (a.enchantment != b.enchantment) {
            Constants.LOG.error("Enchantment {} != {}", (Object)a.enchantment, (Object)b.enchantment);
            return false;
        }
        if (a.level != b.level) {
            Constants.LOG.error("Level {} != {}", (Object)a.level, (Object)b.level);
            return false;
        }
        return true;
    }

    private static <T> boolean assertTagEqual(TagKey<T> a, TagKey<T> b) {
        return Objects.equals(a, b) || Objects.equals(a.location(), b.location());
    }

    private static boolean assertEqual(Ingredient original, Ingredient result) {
        ItemStack[] resultStacks;
        if (Objects.equals(original, result)) {
            return true;
        }
        ItemStack[] originalStacks = original.getItems();
        if (originalStacks.length != (resultStacks = result.getItems()).length) {
            Constants.LOG.error("Size mismatch. original={} result={}", (Object)originalStacks.length, (Object)resultStacks.length);
            return false;
        }
        for (int index = 0; index < originalStacks.length; ++index) {
            if (ItemStackHelper.areStacksEquivalent(originalStacks[index], resultStacks[index])) continue;
            Constants.LOG.error("Mismatch at index {}. original={} result={}", new Object[]{index, originalStacks[index], resultStacks[index]});
            return false;
        }
        return true;
    }

    private static ItemStack[] getTestStacks() {
        return new ItemStack[]{new ItemStack((ItemLike)Items.STONE), new ItemStack((ItemLike)Items.STICK).setHoverName((Component)Component.literal((String)"test")), new ItemStack((ItemLike)Items.STONE_AXE), ItemStack.EMPTY, new ItemStackBuilder((ItemLike)Items.GLOW_ITEM_FRAME).enchant(Enchantments.ALL_DAMAGE_PROTECTION).build(), new ItemStackBuilder((ItemLike)Items.BOOKSHELF).name((Component)Component.literal((String)"HELP")).lore(new Component[]{Component.literal((String)"hello world")}).build()};
    }

    private static CompoundTag[] getTestTags() {
        CompoundTag tag1 = new CompoundTag();
        CompoundTag tag2 = new CompoundTag();
        tag2.put("one", (Tag)IntTag.valueOf((int)33));
        tag2.put("two", (Tag)StringTag.valueOf((String)"hello"));
        CompoundTag tag3 = new CompoundTag();
        tag3.put("one", (Tag)tag2);
        tag3.put("two", (Tag)new ListTag());
        return new CompoundTag[]{tag1, tag2, tag3};
    }
}

