/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.UnaryOperator;
import net.darkhax.bookshelf.api.util.TextHelper;
import net.darkhax.bookshelf.impl.commands.args.FontArgument;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;

public class CommandFont {
    public static LiteralArgumentBuilder<CommandSourceStack> build() {
        LiteralArgumentBuilder font = Commands.literal((String)"font");
        font.then(((LiteralArgumentBuilder)Commands.literal((String)"item").requires(p -> p.hasPermission(2))).then(FontArgument.argument().executes(CommandFont::renameItemWithFont)));
        font.then(((LiteralArgumentBuilder)Commands.literal((String)"block").requires(p -> p.hasPermission(2))).then(FontArgument.argument().then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(CommandFont::renameBlockWithFont))));
        font.then(((LiteralArgumentBuilder)Commands.literal((String)"book").requires(p -> p.hasPermission(2))).then(FontArgument.argument().executes(CommandFont::setBookFont)));
        font.then(((LiteralArgumentBuilder)Commands.literal((String)"say").requires(p -> p.hasPermission(2))).then(FontArgument.argument().then(Commands.argument((String)"message", (ArgumentType)MessageArgument.message()).executes(CommandFont::speakWithFont))));
        return font;
    }

    private static int speakWithFont(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ResourceLocation fontId = FontArgument.getFont(context);
        Component inputMessage = TextHelper.applyFont(MessageArgument.getMessage(context, (String)"message"), fontId);
        MutableComponent txtMessage = Component.translatable((String)"chat.type.announcement", (Object[])new Object[]{((CommandSourceStack)context.getSource()).getDisplayName(), inputMessage});
        ((CommandSourceStack)context.getSource()).getServer().getPlayerList().broadcastSystemMessage((Component)txtMessage, false);
        return 0;
    }

    private static int renameItemWithFont(CommandContext<CommandSourceStack> context) {
        ResourceLocation fontId = FontArgument.getFont(context);
        Entity sender = ((CommandSourceStack)context.getSource()).getEntity();
        if (sender instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)sender;
            ItemStack stack = living.getMainHandItem();
            stack.setHoverName(TextHelper.applyFont(stack.getHoverName(), fontId));
            return 1;
        }
        return 0;
    }

    private static int renameBlockWithFont(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerLevel world = ((CommandSourceStack)context.getSource()).getLevel();
        ResourceLocation fontId = FontArgument.getFont(context);
        BlockPos pos = BlockPosArgument.getLoadedBlockPos(context, (String)"pos");
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile != null) {
            if (tile instanceof BaseContainerBlockEntity) {
                BaseContainerBlockEntity container = (BaseContainerBlockEntity)tile;
                container.setCustomName(TextHelper.applyFont(container.getName(), fontId));
            }
            if (tile instanceof SignBlockEntity) {
                SignBlockEntity sign = (SignBlockEntity)tile;
                sign.updateText(CommandFont.applySignFont(fontId), true);
                sign.updateText(CommandFont.applySignFont(fontId), false);
                sign.getLevel().sendBlockUpdated(sign.getBlockPos(), sign.getBlockState(), sign.getBlockState(), 3);
            }
        }
        return 1;
    }

    private static UnaryOperator<SignText> applySignFont(ResourceLocation fontId) {
        return text -> {
            for (int i = 0; i < 4; ++i) {
                text.setMessage(i, TextHelper.applyFont(text.getMessage(i, false), fontId));
            }
            return text;
        };
    }

    private static int setBookFont(CommandContext<CommandSourceStack> context) {
        LivingEntity living;
        ItemStack stack;
        Item item;
        ResourceLocation fontId = FontArgument.getFont(context);
        Entity sender = ((CommandSourceStack)context.getSource()).getEntity();
        if (sender instanceof LivingEntity && (item = (stack = (living = (LivingEntity)sender).getMainHandItem()).getItem()) instanceof WrittenBookItem) {
            WrittenBookItem book = (WrittenBookItem)item;
            if (stack.hasTag()) {
                stack.setHoverName(TextHelper.applyFont(stack.getHoverName(), fontId));
                CompoundTag stackTag = stack.getTag();
                if (stackTag != null) {
                    ListTag pageData = stackTag.getList("pages", 8);
                    for (int pageNum = 0; pageNum < pageData.size(); ++pageNum) {
                        MutableComponent pageText = Component.Serializer.fromJsonLenient((String)pageData.getString(pageNum));
                        TextHelper.applyFont((Component)pageText, fontId);
                        pageData.set(pageNum, (Tag)StringTag.valueOf((String)Component.Serializer.toJson((Component)pageText)));
                    }
                    stackTag.put("pages", (Tag)pageData);
                }
                return 1;
            }
        }
        return 0;
    }
}

