/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.data.recipes.crafting;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.mixin.accessors.item.crafting.AccessorShapedRecipe;
import net.darkhax.bookshelf.mixin.accessors.item.crafting.AccessorShapedRecipeSerializer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipeCodecs;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.apache.commons.lang3.NotImplementedException;

public final class ShapedDurabilityRecipe
extends ShapedRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    private final int damageAmount;
    private final ItemStack output;

    public ShapedDurabilityRecipe(String group, CraftingBookCategory category, int width, int height, NonNullList<Ingredient> input, ItemStack output, boolean showNotification, int damageAmount) {
        super(group, category, width, height, input, output, showNotification);
        this.damageAmount = damageAmount;
        this.output = output;
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList keptItems = super.getRemainingItems((Container)inv);
        return Services.INVENTORY_HELPER.keepDamageableItems(inv, (NonNullList<ItemStack>)keptItems, this.damageAmount);
    }

    public static final class Serializer
    implements RecipeSerializer<ShapedDurabilityRecipe> {
        public static final Codec<ShapedDurabilityRecipe> CODEC = RawData.CODEC.flatXmap(rawData -> {
            String[] pattern = AccessorShapedRecipe.bookshelf$shrink(rawData.pattern);
            int recipeWidth = pattern[0].length();
            int recipeHeight = pattern.length;
            NonNullList inputGrid = NonNullList.withSize((int)(recipeWidth * recipeHeight), (Object)Ingredient.EMPTY);
            HashSet unresolvedKeys = Sets.newHashSet(rawData.keys.keySet());
            for (int x = 0; x < pattern.length; ++x) {
                String patternRow = pattern[x];
                for (int y = 0; y < patternRow.length(); ++y) {
                    Ingredient matchingIngredient;
                    String patternKey = patternRow.substring(y, y + 1);
                    Ingredient ingredient = matchingIngredient = patternKey.equals(" ") ? Ingredient.EMPTY : rawData.keys.get(patternKey);
                    if (matchingIngredient == null) {
                        return DataResult.error(() -> "Pattern references symbol '" + patternKey + "' but it's not defined in the key");
                    }
                    unresolvedKeys.remove(patternKey);
                    inputGrid.set(y + recipeWidth * x, (Object)matchingIngredient);
                }
            }
            if (!unresolvedKeys.isEmpty()) {
                return DataResult.error(() -> "Key defines symbols that aren't used in pattern: " + unresolvedKeys);
            }
            return DataResult.success((Object)((Object)new ShapedDurabilityRecipe(rawData.group, rawData.category, recipeWidth, recipeHeight, (NonNullList<Ingredient>)inputGrid, rawData.result, rawData.showNotification, rawData.damageAmount)));
        }, data -> {
            throw new NotImplementedException("Serializing ShapedRecipe is not implemented yet.");
        });

        public Codec<ShapedDurabilityRecipe> codec() {
            return CODEC;
        }

        public ShapedDurabilityRecipe fromNetwork(FriendlyByteBuf buffer) {
            int width = buffer.readInt();
            int height = buffer.readInt();
            String group = buffer.readUtf();
            NonNullList input = NonNullList.withSize((int)(width * height), (Object)Ingredient.EMPTY);
            for (int i = 0; i < input.size(); ++i) {
                input.set(i, (Object)Ingredient.fromNetwork((FriendlyByteBuf)buffer));
            }
            ItemStack output = buffer.readItem();
            boolean showNotification = buffer.readBoolean();
            int damageAmount = buffer.readInt();
            CraftingBookCategory category = (CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class);
            return new ShapedDurabilityRecipe(group, category, width, height, (NonNullList<Ingredient>)input, output, showNotification, damageAmount);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapedDurabilityRecipe recipe) {
            buffer.writeInt(recipe.getWidth());
            buffer.writeInt(recipe.getHeight());
            buffer.writeUtf(recipe.getGroup());
            for (Ingredient ingredient : recipe.getIngredients()) {
                ingredient.toNetwork(buffer);
            }
            buffer.writeItem(recipe.output);
            buffer.writeBoolean(recipe.showNotification());
            buffer.writeInt(recipe.damageAmount);
            buffer.writeEnum((Enum)recipe.category());
        }

        private record RawData(String group, CraftingBookCategory category, Map<String, Ingredient> keys, List<String> pattern, ItemStack result, boolean showNotification, int damageAmount) {
            public static final Codec<RawData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.strictOptionalField((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(RawData::group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(RawData::category), (App)ExtraCodecs.strictUnboundedMap(AccessorShapedRecipeSerializer.bookshelf$getSingleCharacterStringCodec(), (Codec)Ingredient.CODEC_NONEMPTY).fieldOf("key").forGetter(RawData::keys), (App)AccessorShapedRecipeSerializer.bookshelf$getPatternCodec().fieldOf("pattern").forGetter(RawData::pattern), (App)CraftingRecipeCodecs.ITEMSTACK_OBJECT_CODEC.fieldOf("results").forGetter(RawData::result), (App)ExtraCodecs.strictOptionalField((Codec)Codec.BOOL, (String)"show_notification", (Object)true).forGetter(RawData::showNotification), (App)Codec.INT.fieldOf("damageAmount").orElse((Object)1).forGetter(RawData::damageAmount)).apply((Applicative)instance, RawData::new));
        }
    }
}

