/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.gametest;

import com.google.common.collect.Iterables;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.impl.gametest.ITestable;
import net.darkhax.bookshelf.mixin.accessors.util.random.AccessorWeightedRandomList;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;

public class TestSerialization<T>
implements ITestable {
    private final String type;
    private final ISerializer<T> serializer;
    private final T singleton;
    private final T[] collection;
    private final BiPredicate<T, T> equality;

    public TestSerialization(String type, ISerializer<T> serializer, T ... collection) {
        this(type, (ISerializer<Object>)serializer, Objects::equals, (Object)collection[0], collection);
    }

    public TestSerialization(String type, ISerializer<T> serializer, BiPredicate<T, T> equality, T ... collection) {
        this(type, serializer, equality, collection[0], collection);
    }

    public TestSerialization(String type, ISerializer<T> serializer, BiPredicate<T, T> equality, T singleton, T ... collection) {
        this.type = type;
        this.serializer = serializer;
        this.equality = equality;
        this.singleton = singleton;
        this.collection = collection;
    }

    @GameTest
    public void testJsonSingleton(GameTestHelper helper) {
        JsonElement toJson = this.serializer.toJSON(this.singleton);
        T fromJson = this.serializer.fromJSON(toJson);
        if (!this.equality.test(this.singleton, fromJson)) {
            helper.fail("Singleton from" + this.type + " JSON does not match! a= " + this.singleton + " b= " + fromJson);
        } else {
            helper.succeed();
        }
    }

    @GameTest
    public void testBytebufSingleton(GameTestHelper helper) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        this.serializer.toByteBuf(buffer, this.singleton);
        T fromBuffer = this.serializer.fromByteBuf(buffer);
        if (!this.equality.test(this.singleton, fromBuffer)) {
            helper.fail("Singleton from" + this.type + " ByteBuf does not match! a= " + this.singleton + " b= " + fromBuffer);
        } else {
            helper.succeed();
        }
    }

    @GameTest
    public void testNbtSingleton(GameTestHelper helper) {
        Tag toNBT = this.serializer.toNBT(this.singleton);
        T fromNBT = this.serializer.fromNBT(toNBT);
        if (!this.equality.test(this.singleton, fromNBT)) {
            helper.fail("Singleton from" + this.type + " NBT does not match! a= " + this.singleton + " b= " + fromNBT);
        } else {
            helper.succeed();
        }
    }

    @GameTest
    public void testJsonWeightedSingleton(GameTestHelper helper) {
        WeightedEntry.Wrapper weightedSingleton = WeightedEntry.wrap(this.singleton, (int)14);
        JsonElement toJson = this.serializer.toJSONWeighted(weightedSingleton);
        WeightedEntry.Wrapper<T> fromJson = this.serializer.fromJSONWeighted(toJson);
        if (!weightedSingleton.getWeight().equals((Object)fromJson.getWeight())) {
            helper.fail("Weight for JSON does not match! a= " + weightedSingleton.getWeight() + " b= " + fromJson.getWeight());
        }
        if (!this.equality.test(this.singleton, fromJson.getData())) {
            helper.fail("Weighted Singleton from" + this.type + " JSON does not match! a= " + this.singleton + " b= " + fromJson.getData());
        } else {
            helper.succeed();
        }
    }

    @GameTest
    public void testBytebufWeightedSingleton(GameTestHelper helper) {
        WeightedEntry.Wrapper weightedSingleton = WeightedEntry.wrap(this.singleton, (int)14);
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        this.serializer.toByteBufWeighted(buffer, weightedSingleton);
        WeightedEntry.Wrapper<T> fromBuffer = this.serializer.fromByteBufWeighted(buffer);
        if (!weightedSingleton.getWeight().equals((Object)fromBuffer.getWeight())) {
            helper.fail("Weight for ByteBuf does not match! a= " + weightedSingleton.getWeight() + " b= " + fromBuffer.getWeight());
        }
        if (!this.equality.test(this.singleton, fromBuffer.getData())) {
            helper.fail("Weighted Singleton from" + this.type + " ByteBuf does not match! a= " + this.singleton + " b= " + fromBuffer.getData());
        } else {
            helper.succeed();
        }
    }

    @GameTest
    public void testJsonOptionalSingleton(GameTestHelper helper) {
        Optional<T> original = Optional.ofNullable(this.singleton);
        JsonElement toJson = this.serializer.toJSONOptional(original);
        Optional<T> fromJson = this.serializer.fromJSONOptional(toJson);
        if (original.isPresent() && fromJson.isPresent() && !this.equality.test(original.get(), fromJson.get())) {
            helper.fail("Optional Singleton from" + this.type + " JSON does not match! a= " + original.get() + " b= " + fromJson.get());
        }
        if (original.isPresent() != fromJson.isPresent()) {
            helper.fail("Optional Singleton from " + this.type + " JSON availability mismatch. a= " + original.isPresent() + " b= " + fromJson.isPresent());
        } else {
            helper.succeed();
        }
    }

    @GameTest
    public void testBytebufOptionalSingleton(GameTestHelper helper) {
        Optional<T> original = Optional.ofNullable(this.singleton);
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        this.serializer.toByteBufOptional(buffer, original);
        Optional<T> fromByteBuf = this.serializer.fromByteBufOptional(buffer);
        if (original.isPresent() && fromByteBuf.isPresent() && !this.equality.test(original.get(), fromByteBuf.get())) {
            helper.fail("Optional Singleton from" + this.type + " ByteBuf does not match! a= " + original.get() + " b= " + fromByteBuf.get());
        }
        if (original.isPresent() != fromByteBuf.isPresent()) {
            helper.fail("Optional Singleton from " + this.type + " ByteBuf availability mismatch. a= " + original.isPresent() + " b= " + fromByteBuf.isPresent());
        } else {
            helper.succeed();
        }
    }

    @GameTest
    public void testJsonEmptyOptionalSingleton(GameTestHelper helper) {
        Optional original = Optional.empty();
        JsonElement toJson = this.serializer.toJSONOptional(original);
        Optional<T> fromJson = this.serializer.fromJSONOptional(toJson);
        if (original.isPresent() || fromJson.isPresent()) {
            helper.fail("Empty Optional Singleton from" + this.type + " JSON was not empty! a= " + original.isPresent() + " b= " + fromJson.isPresent());
        } else {
            helper.succeed();
        }
    }

    @GameTest
    public void testBytebufEmptyOptionalSingleton(GameTestHelper helper) {
        Optional original = Optional.empty();
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        this.serializer.toByteBufOptional(buffer, original);
        Optional<T> fromByteBuf = this.serializer.fromByteBufOptional(buffer);
        if (original.isPresent() || fromByteBuf.isPresent()) {
            helper.fail("Empty Optional Singleton from" + this.type + " JSON was not empty! a= " + original.isPresent() + " b= " + fromByteBuf.isPresent());
        } else {
            helper.succeed();
        }
    }

    @GameTest
    public void testJsonList(GameTestHelper helper) {
        List<T> list = List.of(this.collection);
        JsonElement written = this.serializer.toJSONList(list);
        List<T> read = this.serializer.fromJSONList(written);
        this.assertIterableEqual(helper, list, read);
    }

    @GameTest
    public void testBytebufList(GameTestHelper helper) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        List<T> list = List.of(this.collection);
        this.serializer.toByteBufList(buffer, list);
        List<T> read = this.serializer.fromByteBufList(buffer);
        this.assertIterableEqual(helper, list, read);
    }

    @GameTest
    public void testNbtList(GameTestHelper helper) {
        ListTag listTag;
        Tag tag;
        List<T> list = List.of(this.collection);
        CompoundTag tag2 = new CompoundTag();
        this.serializer.toNBTList(tag2, "test_list", list);
        if (!tag2.contains("test_list")) {
            helper.fail("List was not written to tag.");
        }
        if ((tag = tag2.get("test_list")) instanceof ListTag && (listTag = (ListTag)tag).size() != list.size()) {
            helper.fail("List size does not match on write. Has " + listTag.size() + " expected " + list.size());
        }
        List<T> read = this.serializer.fromNBTList(tag2, "test_list");
        this.assertIterableEqual(helper, list, read);
    }

    @GameTest
    public void testJsonSet(GameTestHelper helper) {
        Set<T> set = this.createSet();
        JsonElement written = this.serializer.toJSONSet(set);
        Set<T> read = this.serializer.fromJSONSet(written);
        this.assertIterableEqual(helper, set, read);
    }

    @GameTest
    public void testBytebufSet(GameTestHelper helper) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        Set<T> set = this.createSet();
        this.serializer.writeByteBufSet(buffer, set);
        Set<T> read = this.serializer.readByteBufSet(buffer);
        this.assertIterableEqual(helper, set, read);
    }

    @GameTest
    public void testJsonWeightedList(GameTestHelper helper) {
        SimpleWeightedRandomList<T> original = this.createWeightedList();
        JsonElement written = this.serializer.toJSONWeightedList(original);
        SimpleWeightedRandomList<T> read = this.serializer.fromJSONWeightedList(written);
        this.assertWeightedListEqual(helper, original, read);
    }

    @GameTest
    public void testBytebufWeightedList(GameTestHelper helper) {
        SimpleWeightedRandomList<T> original = this.createWeightedList();
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        this.serializer.toByteBufWeightedList(buffer, original);
        SimpleWeightedRandomList<T> read = this.serializer.fromByteBufWeightedList(buffer);
        this.assertWeightedListEqual(helper, original, read);
    }

    @GameTest
    public void testJsonListEmpty(GameTestHelper helper) {
        ArrayList list = new ArrayList();
        JsonObject testObj = new JsonObject();
        this.serializer.toJSONList(testObj, "test", list);
        if (testObj.has("test")) {
            helper.fail("Empty list should not be serialized.");
        }
        helper.succeed();
    }

    @GameTest
    public void testJsonListNull(GameTestHelper helper) {
        JsonObject testObj = new JsonObject();
        this.serializer.toJSONList(testObj, "test", null);
        if (testObj.has("test")) {
            helper.fail("Empty list should not be serialized.");
        }
        helper.succeed();
    }

    @GameTest
    public void testJsonNullable(GameTestHelper helper) {
        T value;
        JsonElement json;
        T nullValue;
        JsonElement nullJson = this.serializer.toJSONNullable(null);
        if (nullJson != null) {
            helper.fail("Expected JSON to be null.");
        }
        if ((nullValue = this.serializer.fromJSONNullable(nullJson)) != null) {
            helper.fail("Expected value to be null.");
        }
        if ((json = this.serializer.toJSONNullable(this.singleton)) == null) {
            helper.fail("Expected JSON to not be null.");
        }
        if ((value = this.serializer.fromJSONNullable(json)) == null) {
            helper.fail("Expected value to not be null.");
        }
        if (!this.equality.test(this.singleton, value)) {
            helper.fail("Value written and read do not match.");
        } else {
            helper.succeed();
        }
    }

    @GameTest
    public void testBytebufNullable(GameTestHelper helper) {
        FriendlyByteBuf nullBuffer = new FriendlyByteBuf(Unpooled.buffer());
        this.serializer.toByteBufNullable(nullBuffer, null);
        T nullValue = this.serializer.fromByteBufNullable(nullBuffer);
        if (nullValue != null) {
            helper.fail("Expected value to be null.");
        }
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        this.serializer.toByteBufNullable(buffer, this.singleton);
        T value = this.serializer.fromByteBufNullable(buffer);
        if (value == null) {
            helper.fail("Expected value to not be null.");
        }
        if (!this.equality.test(this.singleton, value)) {
            helper.fail("Value written and read do not match.");
        } else {
            helper.succeed();
        }
    }

    private Set<T> createSet() {
        LinkedHashSet values = new LinkedHashSet();
        Collections.addAll(values, this.collection);
        return values;
    }

    private SimpleWeightedRandomList<T> createWeightedList() {
        SimpleWeightedRandomList.Builder weightedList = SimpleWeightedRandomList.builder();
        for (T value : this.collection) {
            weightedList.add(value, 25);
        }
        return weightedList.build();
    }

    private void assertWeightedListEqual(GameTestHelper helper, SimpleWeightedRandomList<T> original, SimpleWeightedRandomList<T> result) {
        AccessorWeightedRandomList accessOriginal = (AccessorWeightedRandomList)original;
        AccessorWeightedRandomList accessResult = (AccessorWeightedRandomList)result;
        if (accessOriginal.bookshelf$getEntries().size() != accessResult.bookshelf$getEntries().size()) {
            helper.fail("List of type " + this.type + " has incorrect size. Original=" + accessOriginal.bookshelf$getEntries().size() + " Result=" + accessResult.bookshelf$getEntries().size());
        } else {
            for (int index = 0; index < accessOriginal.bookshelf$getEntries().size(); ++index) {
                WeightedEntry.Wrapper a = (WeightedEntry.Wrapper)accessOriginal.bookshelf$getEntries().get(index);
                WeightedEntry.Wrapper b = (WeightedEntry.Wrapper)accessResult.bookshelf$getEntries().get(index);
                if (a.getWeight().asInt() != b.getWeight().asInt()) {
                    helper.fail("Weighted list of " + this.type + " do not match! index=" + index + " a=" + a.getWeight().asInt() + " b=" + b.getWeight().asInt());
                    return;
                }
                if (this.equality.test(a.getData(), b.getData())) continue;
                helper.fail("Weighted list of " + this.type + " do not match! index=" + index + " a=" + a.getData() + " b=" + b.getData());
                return;
            }
            helper.succeed();
        }
    }

    private void assertIterableEqual(GameTestHelper helper, Iterable<T> original, Iterable<T> result) {
        int resultSize;
        int originalSize = Iterables.size(original);
        if (originalSize != (resultSize = Iterables.size(result))) {
            helper.fail("List of type " + this.type + " has incorrect size. Original=" + originalSize + " Result=" + resultSize);
        } else {
            for (int index = 0; index < originalSize; ++index) {
                Object b;
                Object a = Iterables.get(original, (int)index);
                if (this.equality.test(a, b = Iterables.get(result, (int)index))) continue;
                helper.fail("List of " + this.type + " do not match! index=" + index + " a=" + a + " b=" + b);
                return;
            }
            helper.succeed();
        }
    }

    @Override
    public String getDefaultBatch() {
        return "bookshelf_serialization_" + this.type;
    }
}

