/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.darkhax.bookshelf.api.Services;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import org.joml.Matrix4f;

public interface RenderHelper {
    public static final RenderHelper INSTANCE = Services.load(RenderHelper.class);

    public static RenderHelper get() {
        return INSTANCE;
    }

    public void renderFluidBox(PoseStack var1, FluidState var2, Level var3, BlockPos var4, MultiBufferSource var5, int var6, int var7);

    default public int[] argb(int color) {
        int[] colors = new int[]{color >> 24 & 0xFF, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF};
        return colors;
    }

    default public void renderBox(VertexConsumer builder, PoseStack stack, TextureAtlasSprite sprite, int light, int overlay, int[] color) {
        this.renderBox(builder, stack.last().pose(), sprite, light, overlay, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, color);
    }

    default public void renderBox(VertexConsumer builder, PoseStack stack, TextureAtlasSprite sprite, int light, int overlay, float x1, float x2, float y1, float y2, float z1, float z2, int[] color) {
        this.renderBox(builder, stack.last().pose(), sprite, light, overlay, x1, x2, y1, y2, z1, z2, color);
    }

    default public void renderBox(VertexConsumer builder, Matrix4f pos, TextureAtlasSprite sprite, int light, int overlay, float x1, float x2, float y1, float y2, float z1, float z2, int[] color) {
        this.renderFace(builder, pos, sprite, Direction.DOWN, light, overlay, x1, x2, y1, y2, z1, z2, color);
        this.renderFace(builder, pos, sprite, Direction.UP, light, overlay, x1, x2, y1, y2, z1, z2, color);
        this.renderFace(builder, pos, sprite, Direction.NORTH, light, overlay, x1, x2, y1, y2, z1, z2, color);
        this.renderFace(builder, pos, sprite, Direction.SOUTH, light, overlay, x1, x2, y1, y2, z1, z2, color);
        this.renderFace(builder, pos, sprite, Direction.WEST, light, overlay, x1, x2, y1, y2, z1, z2, color);
        this.renderFace(builder, pos, sprite, Direction.EAST, light, overlay, x1, x2, y1, y2, z1, z2, color);
    }

    default public void renderFace(VertexConsumer builder, Matrix4f pos, TextureAtlasSprite sprite, Direction side, int light, int overlay, float x1, float x2, float y1, float y2, float z1, float z2, int[] color) {
        double px1 = x1 * 16.0f;
        double px2 = x2 * 16.0f;
        double py1 = y1 * 16.0f;
        double py2 = y2 * 16.0f;
        double pz1 = z1 * 16.0f;
        double pz2 = z2 * 16.0f;
        switch (side) {
            case DOWN: {
                float u1 = sprite.getU(px1);
                float u2 = sprite.getU(px2);
                float v1 = sprite.getV(pz1);
                float v2 = sprite.getV(pz2);
                builder.vertex(pos, x1, y1, z2).color(color[1], color[2], color[3], color[0]).uv(u1, v2).overlayCoords(overlay).uv2(light).normal(0.0f, -1.0f, 0.0f).endVertex();
                builder.vertex(pos, x1, y1, z1).color(color[1], color[2], color[3], color[0]).uv(u1, v1).overlayCoords(overlay).uv2(light).normal(0.0f, -1.0f, 0.0f).endVertex();
                builder.vertex(pos, x2, y1, z1).color(color[1], color[2], color[3], color[0]).uv(u2, v1).overlayCoords(overlay).uv2(light).normal(0.0f, -1.0f, 0.0f).endVertex();
                builder.vertex(pos, x2, y1, z2).color(color[1], color[2], color[3], color[0]).uv(u2, v2).overlayCoords(overlay).uv2(light).normal(0.0f, -1.0f, 0.0f).endVertex();
                break;
            }
            case UP: {
                float u1 = sprite.getU(px1);
                float u2 = sprite.getU(px2);
                float v1 = sprite.getV(pz1);
                float v2 = sprite.getV(pz2);
                builder.vertex(pos, x1, y2, z2).color(color[1], color[2], color[3], color[0]).uv(u1, v2).overlayCoords(overlay).uv2(light).normal(0.0f, 1.0f, 0.0f).endVertex();
                builder.vertex(pos, x2, y2, z2).color(color[1], color[2], color[3], color[0]).uv(u2, v2).overlayCoords(overlay).uv2(light).normal(0.0f, 1.0f, 0.0f).endVertex();
                builder.vertex(pos, x2, y2, z1).color(color[1], color[2], color[3], color[0]).uv(u2, v1).overlayCoords(overlay).uv2(light).normal(0.0f, 1.0f, 0.0f).endVertex();
                builder.vertex(pos, x1, y2, z1).color(color[1], color[2], color[3], color[0]).uv(u1, v1).overlayCoords(overlay).uv2(light).normal(0.0f, 1.0f, 0.0f).endVertex();
                break;
            }
            case NORTH: {
                float u1 = sprite.getU(px1);
                float u2 = sprite.getU(px2);
                float v1 = sprite.getV(py1);
                float v2 = sprite.getV(py2);
                builder.vertex(pos, x1, y1, z1).color(color[1], color[2], color[3], color[0]).uv(u1, v1).overlayCoords(overlay).uv2(light).normal(0.0f, 0.0f, -1.0f).endVertex();
                builder.vertex(pos, x1, y2, z1).color(color[1], color[2], color[3], color[0]).uv(u1, v2).overlayCoords(overlay).uv2(light).normal(0.0f, 0.0f, -1.0f).endVertex();
                builder.vertex(pos, x2, y2, z1).color(color[1], color[2], color[3], color[0]).uv(u2, v2).overlayCoords(overlay).uv2(light).normal(0.0f, 0.0f, -1.0f).endVertex();
                builder.vertex(pos, x2, y1, z1).color(color[1], color[2], color[3], color[0]).uv(u2, v1).overlayCoords(overlay).uv2(light).normal(0.0f, 0.0f, -1.0f).endVertex();
                break;
            }
            case SOUTH: {
                float u1 = sprite.getU(px1);
                float u2 = sprite.getU(px2);
                float v1 = sprite.getV(py1);
                float v2 = sprite.getV(py2);
                builder.vertex(pos, x2, y1, z2).color(color[1], color[2], color[3], color[0]).uv(u2, v1).overlayCoords(overlay).uv2(light).normal(0.0f, 0.0f, 1.0f).endVertex();
                builder.vertex(pos, x2, y2, z2).color(color[1], color[2], color[3], color[0]).uv(u2, v2).overlayCoords(overlay).uv2(light).normal(0.0f, 0.0f, 1.0f).endVertex();
                builder.vertex(pos, x1, y2, z2).color(color[1], color[2], color[3], color[0]).uv(u1, v2).overlayCoords(overlay).uv2(light).normal(0.0f, 0.0f, 1.0f).endVertex();
                builder.vertex(pos, x1, y1, z2).color(color[1], color[2], color[3], color[0]).uv(u1, v1).overlayCoords(overlay).uv2(light).normal(0.0f, 0.0f, 1.0f).endVertex();
                break;
            }
            case WEST: {
                float u1 = sprite.getU(py1);
                float u2 = sprite.getU(py2);
                float v1 = sprite.getV(pz1);
                float v2 = sprite.getV(pz2);
                builder.vertex(pos, x1, y1, z2).color(color[1], color[2], color[3], color[0]).uv(u1, v2).overlayCoords(overlay).uv2(light).normal(-1.0f, 0.0f, 0.0f).endVertex();
                builder.vertex(pos, x1, y2, z2).color(color[1], color[2], color[3], color[0]).uv(u2, v2).overlayCoords(overlay).uv2(light).normal(-1.0f, 0.0f, 0.0f).endVertex();
                builder.vertex(pos, x1, y2, z1).color(color[1], color[2], color[3], color[0]).uv(u2, v1).overlayCoords(overlay).uv2(light).normal(-1.0f, 0.0f, 0.0f).endVertex();
                builder.vertex(pos, x1, y1, z1).color(color[1], color[2], color[3], color[0]).uv(u1, v1).overlayCoords(overlay).uv2(light).normal(-1.0f, 0.0f, 0.0f).endVertex();
                break;
            }
            case EAST: {
                float u1 = sprite.getU(py1);
                float u2 = sprite.getU(py2);
                float v1 = sprite.getV(pz1);
                float v2 = sprite.getV(pz2);
                builder.vertex(pos, x2, y1, z1).color(color[1], color[2], color[3], color[0]).uv(u1, v1).overlayCoords(overlay).uv2(light).normal(1.0f, 0.0f, 0.0f).endVertex();
                builder.vertex(pos, x2, y2, z1).color(color[1], color[2], color[3], color[0]).uv(u2, v1).overlayCoords(overlay).uv2(light).normal(1.0f, 0.0f, 0.0f).endVertex();
                builder.vertex(pos, x2, y2, z2).color(color[1], color[2], color[3], color[0]).uv(u2, v2).overlayCoords(overlay).uv2(light).normal(1.0f, 0.0f, 0.0f).endVertex();
                builder.vertex(pos, x2, y1, z2).color(color[1], color[2], color[3], color[0]).uv(u1, v2).overlayCoords(overlay).uv2(light).normal(1.0f, 0.0f, 0.0f).endVertex();
            }
        }
    }
}

