/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.data.recipes.crafting;

import com.google.gson.JsonObject;
import java.util.Map;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.bookshelf.mixin.accessors.item.crafting.AccessorShapedRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public final class ShapedDurabilityRecipe
extends ShapedRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    private final int damageAmount;
    private final ItemStack output;

    public ShapedDurabilityRecipe(ResourceLocation id, String group, CraftingBookCategory category, int width, int height, NonNullList<Ingredient> input, ItemStack output, int damageAmount) {
        super(id, group, category, width, height, input, output);
        this.damageAmount = damageAmount;
        this.output = output;
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList keptItems = super.getRemainingItems((Container)inv);
        return Services.INVENTORY_HELPER.keepDamageableItems(inv, (NonNullList<ItemStack>)keptItems, this.damageAmount);
    }

    public static final class Serializer
    implements RecipeSerializer<ShapedDurabilityRecipe> {
        public ShapedDurabilityRecipe fromJson(ResourceLocation id, JsonObject json) {
            String group = Serializers.STRING.fromJSON(json, "group", "");
            Map<String, Ingredient> ingredients = AccessorShapedRecipe.bookshelf$keyFromJson(GsonHelper.getAsJsonObject((JsonObject)json, (String)"key"));
            String[] pattern = AccessorShapedRecipe.bookshelf$shrink(AccessorShapedRecipe.bookshelf$patternFromJson(GsonHelper.getAsJsonArray((JsonObject)json, (String)"pattern")));
            int width = pattern[0].length();
            int height = pattern.length;
            NonNullList<Ingredient> inputs = AccessorShapedRecipe.bookshelf$dissolvePattern(pattern, ingredients, width, height);
            ItemStack output = ShapedRecipe.itemStackFromJson((JsonObject)GsonHelper.getAsJsonObject((JsonObject)json, (String)"result"));
            int damageAmount = Serializers.INT.fromJSON(json, "damageAmount", 1);
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.CODEC.byName(GsonHelper.getAsString((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            return new ShapedDurabilityRecipe(id, group, category, width, height, inputs, output, damageAmount);
        }

        public ShapedDurabilityRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int width = buffer.readInt();
            int height = buffer.readInt();
            String group = buffer.readUtf();
            NonNullList input = NonNullList.withSize((int)(width * height), (Object)Ingredient.EMPTY);
            for (int i = 0; i < input.size(); ++i) {
                input.set(i, (Object)Ingredient.fromNetwork((FriendlyByteBuf)buffer));
            }
            ItemStack output = buffer.readItem();
            int damageAmount = buffer.readInt();
            CraftingBookCategory category = (CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class);
            return new ShapedDurabilityRecipe(recipeId, group, category, width, height, (NonNullList<Ingredient>)input, output, damageAmount);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapedDurabilityRecipe recipe) {
            buffer.writeInt(recipe.getWidth());
            buffer.writeInt(recipe.getHeight());
            buffer.writeUtf(recipe.getGroup());
            for (Ingredient ingredient : recipe.getIngredients()) {
                ingredient.toNetwork(buffer);
            }
            buffer.writeItem(recipe.output);
            buffer.writeInt(recipe.damageAmount);
            buffer.writeEnum((Enum)recipe.category());
        }
    }
}

