/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.data.recipes.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.darkhax.bookshelf.api.Services;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class ShapelessDurabilityRecipe
extends ShapelessRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    private final ItemStack output;
    private final int damageAmount;

    public ShapelessDurabilityRecipe(ResourceLocation recipeId, String group, CraftingBookCategory category, ItemStack result, NonNullList<Ingredient> ingredients, int damageAmount) {
        super(recipeId, group, category, result, ingredients);
        this.damageAmount = damageAmount;
        this.output = result;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList keptItems = super.getRemainingItems((Container)inv);
        return Services.INVENTORY_HELPER.keepDamageableItems(inv, (NonNullList<ItemStack>)keptItems, this.damageAmount);
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public static class Serializer
    implements RecipeSerializer<ShapelessDurabilityRecipe> {
        public ShapelessDurabilityRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.getAsString((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> inputs = Serializer.readIngredients(GsonHelper.getAsJsonArray((JsonObject)json, (String)"ingredients"));
            ItemStack output = ShapedRecipe.itemStackFromJson((JsonObject)GsonHelper.getAsJsonObject((JsonObject)json, (String)"result"));
            int damageAmount = GsonHelper.getAsInt((JsonObject)json, (String)"damageAmount", (int)1);
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.CODEC.byName(GsonHelper.getAsString((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            if (inputs.isEmpty()) {
                throw new JsonSyntaxException("No ingredients were found for the recipe!");
            }
            if (inputs.size() > 9) {
                throw new JsonSyntaxException("Too many ingredients. Maximum is 9 but " + inputs.size() + " were given.");
            }
            if (output.isEmpty()) {
                throw new JsonSyntaxException("The output of the recipe must not be empty!");
            }
            return new ShapelessDurabilityRecipe(recipeId, group, category, output, inputs, damageAmount);
        }

        public ShapelessDurabilityRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.readUtf(Short.MAX_VALUE);
            int inputCount = buffer.readVarInt();
            NonNullList inputs = NonNullList.withSize((int)inputCount, (Object)Ingredient.EMPTY);
            for (int i = 0; i < inputCount; ++i) {
                inputs.set(i, (Object)Ingredient.fromNetwork((FriendlyByteBuf)buffer));
            }
            CraftingBookCategory category = (CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class);
            ItemStack output = buffer.readItem();
            int damageAmount = buffer.readVarInt();
            return new ShapelessDurabilityRecipe(recipeId, group, category, output, (NonNullList<Ingredient>)inputs, damageAmount);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapelessDurabilityRecipe toWrite) {
            buffer.writeUtf(toWrite.getGroup());
            buffer.writeVarInt(toWrite.getIngredients().size());
            for (Ingredient ingredient : toWrite.getIngredients()) {
                ingredient.toNetwork(buffer);
            }
            buffer.writeEnum((Enum)toWrite.category());
            buffer.writeItem(toWrite.output);
            buffer.writeVarInt(toWrite.damageAmount);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray json) {
            NonNullList ingredients = NonNullList.create();
            for (JsonElement element : json) {
                Ingredient ingredient = Ingredient.fromJson((JsonElement)element);
                if (ingredient.isEmpty()) continue;
                ingredients.add((Object)ingredient);
            }
            return ingredients;
        }
    }
}

