/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.StringJoiner;
import java.util.function.Function;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.bookshelf.api.util.TextHelper;
import net.darkhax.bookshelf.impl.commands.args.HandArgument;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class CommandHand {
    public static LiteralArgumentBuilder<CommandSourceStack> build() {
        LiteralArgumentBuilder hand = Commands.literal((String)"hand");
        hand.then(HandArgument.arg().executes(CommandHand::printHeldStack));
        return hand;
    }

    private static int printHeldStack(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        OutputType type = HandArgument.get(context);
        Entity sender = ((CommandSourceStack)context.getSource()).getEntity();
        if (sender instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)sender;
            String stackOutput = type.converter.apply(living.getMainHandItem());
            ((CommandSourceStack)context.getSource()).sendSuccess((Component)TextHelper.textWithCopy(stackOutput), false);
        }
        return 1;
    }

    public static enum OutputType {
        STRING(OutputType::getAsString),
        INGREDIENT(OutputType::getAsIngredient),
        STACK_JSON(OutputType::getAsStackJson),
        SNBT(OutputType::getAsSNBT),
        ID(OutputType::getAsID),
        TAGS(OutputType::getTags);

        private final Function<ItemStack, String> converter;

        private OutputType(Function<ItemStack, String> converter) {
            this.converter = converter;
        }

        private static String getAsString(ItemStack stack) {
            return stack.toString();
        }

        private static String getAsIngredient(ItemStack stack) {
            return Serializers.INGREDIENT.toJSON(Ingredient.of((ItemStack[])new ItemStack[]{stack})).toString();
        }

        private static String getAsStackJson(ItemStack stack) {
            return Serializers.ITEM_STACK.toJSON(stack).toString();
        }

        public static String getAsSNBT(ItemStack stack) {
            return stack.save(new CompoundTag()).getAsString();
        }

        public static String getAsID(ItemStack stack) {
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
            return id != null ? id.toString() : null;
        }

        public static String getTags(ItemStack stack) {
            StringJoiner joiner = new StringJoiner("\n");
            stack.getItem().builtInRegistryHolder().tags().forEach(tag -> joiner.add(tag.location().toString()));
            return joiner.toString();
        }
    }
}

