/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.NBTParseException;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;

public class SerializerItemStack
implements ISerializer<ItemStack> {
    public static final ISerializer<ItemStack> SERIALIZER = new SerializerItemStack();

    private SerializerItemStack() {
    }

    @Override
    public ItemStack fromJSON(JsonElement json) {
        if (json instanceof JsonObject) {
            JsonObject obj = (JsonObject)json;
            ResourceLocation identifier = new ResourceLocation(GsonHelper.getAsString((JsonObject)obj, (String)"item"));
            if (BuiltInRegistries.ITEM.get(identifier) == Items.AIR) {
                return ItemStack.EMPTY;
            }
            return ShapedRecipe.itemStackFromJson((JsonObject)obj);
        }
        if (json.isJsonPrimitive()) {
            return new ItemStack((ItemLike)Serializers.ITEM.fromJSON(json));
        }
        throw new JsonParseException("Expected JSON object, got " + GsonHelper.getType((JsonElement)json));
    }

    @Override
    public JsonElement toJSON(ItemStack toWrite) {
        JsonObject json = new JsonObject();
        json.add("item", Serializers.ITEM.toJSON(toWrite.getItem()));
        json.addProperty("count", (Number)toWrite.getCount());
        if (toWrite.hasTag()) {
            json.add("nbt", Serializers.COMPOUND_TAG.toJSON(toWrite.getTag()));
        }
        return json;
    }

    @Override
    public ItemStack fromByteBuf(FriendlyByteBuf buffer) {
        return buffer.readItem();
    }

    @Override
    public void toByteBuf(FriendlyByteBuf buffer, ItemStack toWrite) {
        buffer.writeItem(toWrite);
    }

    @Override
    public Tag toNBT(ItemStack toWrite) {
        return toWrite.save(new CompoundTag());
    }

    @Override
    public ItemStack fromNBT(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)nbt;
            return ItemStack.of((CompoundTag)compound);
        }
        if (nbt instanceof StringTag) {
            StringTag string = (StringTag)nbt;
            return new ItemStack((ItemLike)Serializers.ITEM.fromNBT((Tag)string));
        }
        throw new NBTParseException("Expected NBT to be a compound tag or string. Class was " + nbt.getClass() + " with ID " + nbt.getId() + " instead.");
    }
}

