/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.math.Vector3f;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.NBTParseException;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class SerializerVector3f
implements ISerializer<Vector3f> {
    public static final ISerializer<Vector3f> SERIALIZER = new SerializerVector3f();

    @Override
    public Vector3f fromJSON(JsonElement json) {
        if (json.isJsonObject()) {
            JsonObject object = json.getAsJsonObject();
            float x = Serializers.FLOAT.fromJSON(object, "x").floatValue();
            float y = Serializers.FLOAT.fromJSON(object, "y").floatValue();
            float z = Serializers.FLOAT.fromJSON(object, "z").floatValue();
            return new Vector3f(x, y, z);
        }
        if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            if (array.size() == 3) {
                return new Vector3f(array.get(0).getAsFloat(), array.get(1).getAsFloat(), array.get(2).getAsFloat());
            }
            throw new JsonParseException("Invalid number of args in array. Expected 3 but got " + array.size());
        }
        throw new JsonParseException("Vector3f data is not in a readable format.");
    }

    @Override
    public JsonElement toJSON(Vector3f toWrite) {
        JsonObject object = new JsonObject();
        object.addProperty("x", (Number)Float.valueOf(toWrite.x()));
        object.addProperty("y", (Number)Float.valueOf(toWrite.y()));
        object.addProperty("z", (Number)Float.valueOf(toWrite.z()));
        return object;
    }

    @Override
    public Vector3f fromByteBuf(FriendlyByteBuf buffer) {
        return new Vector3f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
    }

    @Override
    public void toByteBuf(FriendlyByteBuf buffer, Vector3f toWrite) {
        buffer.writeFloat(toWrite.x());
        buffer.writeFloat(toWrite.y());
        buffer.writeFloat(toWrite.z());
    }

    @Override
    public Tag toNBT(Vector3f toWrite) {
        CompoundTag tag = new CompoundTag();
        tag.putFloat("x", toWrite.x());
        tag.putFloat("y", toWrite.y());
        tag.putFloat("z", toWrite.z());
        return tag;
    }

    @Override
    public Vector3f fromNBT(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)nbt;
            float x = compound.getFloat("x");
            float y = compound.getFloat("y");
            float z = compound.getFloat("z");
            return new Vector3f(x, y, z);
        }
        if (nbt instanceof ListTag) {
            ListTag list = (ListTag)nbt;
            if (list.size() == 3) {
                return new Vector3f(Serializers.FLOAT.fromNBT(list.get(0)).floatValue(), Serializers.FLOAT.fromNBT(list.get(1)).floatValue(), Serializers.FLOAT.fromNBT(list.get(2)).floatValue());
            }
            throw new NBTParseException("Invalid number of args in array. Expected 3 but got " + list.size());
        }
        throw new NBTParseException("Vector3f data is not in a readable format.");
    }
}

