/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.crafting.Ingredient;

public class SerializerIngredient
implements ISerializer<Ingredient> {
    public static final ISerializer<Ingredient> SERIALIZER = new SerializerIngredient();

    private SerializerIngredient() {
    }

    @Override
    public Ingredient fromJSON(JsonElement json) {
        JsonArray array;
        if (json instanceof JsonArray && (array = (JsonArray)json).isEmpty()) {
            return Ingredient.EMPTY;
        }
        return Ingredient.fromJson((JsonElement)json);
    }

    @Override
    public JsonElement toJSON(Ingredient toWrite) {
        return toWrite.toJson();
    }

    @Override
    public Ingredient fromByteBuf(FriendlyByteBuf buffer) {
        return Ingredient.fromNetwork((FriendlyByteBuf)buffer);
    }

    @Override
    public void toByteBuf(FriendlyByteBuf buffer, Ingredient toWrite) {
        toWrite.toNetwork(buffer);
    }

    @Override
    public Tag toNBT(Ingredient toWrite) {
        return Serializers.STRING.toNBT(this.toJSONString(toWrite));
    }

    @Override
    public Ingredient fromNBT(Tag nbt) {
        return (Ingredient)this.fromJSONString(Serializers.STRING.fromNBT(nbt));
    }
}

