/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.mixin.entity;

import net.darkhax.bookshelf.api.block.ILightningConductive;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={LightningBolt.class})
public class MixinLightningBolt {
    @Inject(method={"powerLightningRod()V"}, at={@At(value="RETURN")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onStrikeBlock(CallbackInfo callback, BlockPos strikePos, BlockState strikeState) {
        LightningBolt self = (LightningBolt)this;
        Block strikeBlock = strikeState.getBlock();
        if (strikeBlock instanceof ILightningConductive) {
            ILightningConductive extended = (ILightningConductive)strikeBlock;
            ((ILightningConductive)strikeBlock).onDirectLightningStrike(self.level, strikePos, strikeState, self);
        }
        if (MixinLightningBolt.canRedirect(self.level, strikePos, strikeState)) {
            for (Direction direction : MixinLightningBolt.getRedirectionSides(self.level, strikePos, strikeState)) {
                BlockPos indirectPos = strikePos.relative(direction);
                BlockState indirectState = self.level.getBlockState(indirectPos);
                Block block = indirectState.getBlock();
                if (!(block instanceof ILightningConductive)) continue;
                ILightningConductive extended = (ILightningConductive)block;
                extended.onIndirectLightingStrike(self.level, strikePos, strikeState, indirectPos, indirectState, self);
            }
        }
    }

    @Unique
    private static boolean canRedirect(Level world, BlockPos pos, BlockState state) {
        ILightningConductive extended;
        Block block;
        return state.is(Blocks.LIGHTNING_ROD) || (block = state.getBlock()) instanceof ILightningConductive && (extended = (ILightningConductive)block).canRedirectLightning(world, pos, state);
    }

    @Unique
    private static Direction[] getRedirectionSides(Level world, BlockPos pos, BlockState state) {
        if (state.is(Blocks.LIGHTNING_ROD)) {
            return ILightningConductive.LIGHTNING_REDIRECTION_FACES;
        }
        Block block = state.getBlock();
        if (block instanceof ILightningConductive) {
            ILightningConductive extended = (ILightningConductive)block;
            return extended.getLightningRedirectionFaces(world, pos, state);
        }
        return ILightningConductive.NO_REDIRECTION_FACES;
    }
}

