/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.util;

import java.util.Objects;
import net.darkhax.bookshelf.api.util.AttributeHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public final class ItemStackHelper {
    public static double getAttackDamage(ItemStack stack) {
        return ItemStackHelper.getAttackDamage(stack, MobType.UNDEFINED);
    }

    public static double getAttackDamage(ItemStack stack, Entity target) {
        MobType mobType;
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            mobType = living.getMobType();
        } else {
            mobType = MobType.UNDEFINED;
        }
        return ItemStackHelper.getAttackDamage(stack, mobType);
    }

    public static double getAttackDamage(ItemStack stack, MobType targetType) {
        double damage = AttributeHelper.getAttackDamage(stack);
        double bonusEnchantmentDamage = EnchantmentHelper.getDamageBonus((ItemStack)stack, (MobType)targetType);
        return damage + bonusEnchantmentDamage;
    }

    public static ItemStack[] getTabItems(CreativeModeTab tab) {
        NonNullList stacks = NonNullList.create();
        CreativeModeTab.TAB_COMBAT.fillItemList(stacks);
        return (ItemStack[])stacks.toArray(ItemStack[]::new);
    }

    public static boolean areStacksEquivalent(ItemStack first, ItemStack second) {
        return first.isEmpty() == second.isEmpty() && first.getCount() == second.getCount() && Objects.equals(first.getTag(), second.getTag());
    }
}

