/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.util;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.Constants;
import net.darkhax.bookshelf.api.inventory.ContainerInventoryAccess;
import net.darkhax.bookshelf.api.inventory.IInventoryAccess;
import net.darkhax.bookshelf.api.inventory.WorldlyContainerInventoryAccess;
import net.darkhax.bookshelf.mixin.inventory.AccessorCraftingContainer;
import net.darkhax.bookshelf.mixin.inventory.AccessorCraftingMenu;
import net.darkhax.bookshelf.mixin.inventory.AccessorInventoryMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public interface IInventoryHelper {
    @Nullable
    default public AbstractContainerMenu getCraftingContainer(CraftingContainer container) {
        AbstractContainerMenu abstractContainerMenu;
        if (container instanceof AccessorCraftingContainer) {
            AccessorCraftingContainer accessor = (AccessorCraftingContainer)container;
            abstractContainerMenu = accessor.bookshelf$getMenu();
        } else {
            abstractContainerMenu = null;
        }
        return abstractContainerMenu;
    }

    @Nullable
    default public Player getCraftingPlayer(Container container) {
        if (container instanceof Inventory) {
            Inventory playerInv = (Inventory)container;
            return playerInv.player;
        }
        if (container instanceof CraftingContainer) {
            CraftingContainer crafting = (CraftingContainer)container;
            AbstractContainerMenu menu = this.getCraftingContainer(crafting);
            if (menu instanceof AccessorCraftingMenu) {
                AccessorCraftingMenu accessor = (AccessorCraftingMenu)menu;
                return accessor.bookshelf$getPlayer();
            }
            if (menu instanceof AccessorInventoryMenu) {
                AccessorInventoryMenu accessor = (AccessorInventoryMenu)menu;
                return accessor.bookshelf$getOwner();
            }
        }
        return null;
    }

    default public ItemStack damageStack(ItemStack stack, int amount, @Nullable LivingEntity owner, @Nullable EquipmentSlot slot) {
        if (stack.isDamageableItem()) {
            RandomSource random;
            RandomSource randomSource = random = owner != null ? owner.getRandom() : Constants.RANDOM_SOURCE;
            if (owner != null) {
                stack.hurtAndBreak(amount, owner, e -> {
                    if (slot != null) {
                        e.broadcastBreakEvent(slot);
                    }
                });
            } else if (stack.hurt(amount, random, null)) {
                stack.shrink(1);
                stack.setDamageValue(0);
            }
        }
        return stack;
    }

    default public NonNullList<ItemStack> keepDamageableItems(CraftingContainer inv, NonNullList<ItemStack> keptItems, int damageAmount) {
        Player player = this.getCraftingPlayer((Container)inv);
        RandomSource random = player != null ? player.getRandom() : Constants.RANDOM_SOURCE;
        for (int i = 0; i < keptItems.size(); ++i) {
            ItemStack stack;
            ItemStack input = inv.getItem(i).copy();
            if (!input.getItem().canBeDepleted() && (!input.hasTag() || !input.getTag().getBoolean("Unbreaking")) || (stack = this.damageStack(input, damageAmount, (LivingEntity)player, null)).isEmpty()) continue;
            keptItems.set(i, (Object)stack);
        }
        return keptItems;
    }

    default public NonNullList<ItemStack> toList(Container inventory) {
        NonNullList items = NonNullList.withSize((int)inventory.getContainerSize(), (Object)ItemStack.EMPTY);
        this.applyForEach(inventory, (arg_0, arg_1) -> ((NonNullList)items).set(arg_0, arg_1));
        return items;
    }

    default public void fill(Container inventory, NonNullList<ItemStack> fillWith) {
        if (inventory.getContainerSize() != fillWith.size()) {
            throw new IllegalStateException("Inventory size did not match! inv_size=" + inventory.getContainerSize() + " fill_size=" + fillWith.size());
        }
        for (int slotId = 0; slotId < fillWith.size(); ++slotId) {
            inventory.setItem(slotId, (ItemStack)fillWith.get(slotId));
        }
    }

    default public void applyForEach(Container inventory, Consumer<ItemStack> action) {
        for (int slotId = 0; slotId < inventory.getContainerSize(); ++slotId) {
            action.accept(inventory.getItem(slotId));
        }
    }

    default public void applyForEach(Container inventory, BiConsumer<Integer, ItemStack> action) {
        for (int slotId = 0; slotId < inventory.getContainerSize(); ++slotId) {
            action.accept(slotId, inventory.getItem(slotId));
        }
    }

    default public boolean canItemsStack(ItemStack original, ItemStack toStack) {
        return !toStack.isEmpty() && original.sameItem(toStack) && original.hasTag() == toStack.hasTag() && (!original.hasTag() || original.getTag().equals((Object)toStack.getTag()));
    }

    @Nullable
    default public IInventoryAccess getInventory(Level level, BlockPos pos, @Nullable Direction direction) {
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof WorldlyContainerHolder) {
            WorldlyContainerHolder holder = (WorldlyContainerHolder)block;
            WorldlyContainer container = holder.getContainer(state, (LevelAccessor)level, pos);
            if (container != null) {
                return new ContainerInventoryAccess<WorldlyContainer>(container);
            }
        } else {
            BlockEntity be = level.getBlockEntity(pos);
            if (be instanceof Container) {
                Container container = (Container)be;
                if (container instanceof WorldlyContainer) {
                    WorldlyContainer worldly = (WorldlyContainer)container;
                    return new WorldlyContainerInventoryAccess<WorldlyContainer>(worldly);
                }
                return new ContainerInventoryAccess<Container>(container);
            }
        }
        return null;
    }
}

