/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import java.util.Optional;
import net.darkhax.bookshelf.Constants;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.NBTParseException;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class SerializerBlockState
implements ISerializer<BlockState> {
    public static final ISerializer<BlockState> SERIALIZER = new SerializerBlockState();

    private SerializerBlockState() {
    }

    @Override
    public BlockState fromJSON(JsonElement json) {
        if (json.isJsonObject()) {
            JsonObject obj = json.getAsJsonObject();
            Block block = Serializers.BLOCK.fromJSON(obj, "block");
            BlockState state = block.defaultBlockState();
            if (obj.has("properties")) {
                JsonElement properties = obj.get("properties");
                for (Map.Entry property : properties.getAsJsonObject().entrySet()) {
                    state = this.readProperty(state, (String)property.getKey(), (JsonElement)property.getValue());
                }
            }
            return state;
        }
        throw new JsonParseException("Expected properties to be an object. Recieved " + GsonHelper.getType((JsonElement)json));
    }

    @Override
    public JsonElement toJSON(BlockState toWrite) {
        JsonObject json = new JsonObject();
        json.add("block", Serializers.BLOCK.toJSON(toWrite.getBlock()));
        JsonObject properties = new JsonObject();
        for (Property prop : toWrite.getProperties()) {
            if (prop instanceof IntegerProperty) {
                properties.addProperty(prop.getName(), (Number)((Object)toWrite.getValue((Property)((IntegerProperty)prop))));
                continue;
            }
            if (prop instanceof BooleanProperty) {
                properties.addProperty(prop.getName(), (Boolean)toWrite.getValue((Property)((BooleanProperty)prop)));
                continue;
            }
            properties.addProperty(prop.getName(), prop.getName(toWrite.getValue(prop)));
        }
        json.add("properties", (JsonElement)properties);
        return json;
    }

    @Override
    public BlockState fromByteBuf(FriendlyByteBuf buffer) {
        return Block.stateById((int)buffer.readInt());
    }

    @Override
    public void toByteBuf(FriendlyByteBuf buffer, BlockState toWrite) {
        buffer.writeInt(Block.getId((BlockState)toWrite));
    }

    private BlockState readProperty(BlockState state, String propName, JsonElement propValue) {
        Property blockProperty = state.getBlock().getStateDefinition().getProperty(propName);
        if (blockProperty != null) {
            if (propValue.isJsonPrimitive()) {
                String valueString = propValue.getAsString();
                Optional parsedValue = blockProperty.getValue(valueString);
                if (parsedValue.isPresent()) {
                    try {
                        return (BlockState)state.setValue(blockProperty, (Comparable)parsedValue.get());
                    }
                    catch (Exception e) {
                        Constants.LOG.error("Failed to update state for block {}. The mod that adds this block may have an issue.", (Object)Registry.BLOCK.getId((Object)state.getBlock()));
                        Constants.LOG.trace("Failed to read blockstate from JSON property.", (Throwable)e);
                        throw e;
                    }
                }
                throw new JsonSyntaxException("The property " + propName + " with value " + valueString + " coul not be parsed!");
            }
            throw new JsonSyntaxException("Expected property value for " + propName + " to be primitive string. Got " + GsonHelper.getType((JsonElement)propValue));
        }
        throw new JsonSyntaxException("The property " + propName + " is not valid for block " + Registry.BLOCK.getId((Object)state.getBlock()));
    }

    @Override
    public Tag toNBT(BlockState toWrite) {
        return NbtUtils.writeBlockState((BlockState)toWrite);
    }

    @Override
    public BlockState fromNBT(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)nbt;
            return NbtUtils.readBlockState((CompoundTag)compound);
        }
        throw new NBTParseException("Expected NBT to be a compound tag. Class was " + nbt.getClass() + " with ID " + nbt.getId() + " instead.");
    }
}

