/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.block.entity;

import java.util.Set;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.block.entity.InventoryBlockEntity;
import net.darkhax.bookshelf.api.function.CachedSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class WorldlyInventoryBlockEntity<T extends Container>
extends InventoryBlockEntity<T>
implements WorldlyContainer {
    private final CachedSupplier<int[]> fallbackSlots = CachedSupplier.cache(() -> IntStream.range(0, this.getContainerSize()).toArray());

    public WorldlyInventoryBlockEntity(BlockEntityType type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public int getContainerSize() {
        return this.getInventory().getContainerSize();
    }

    public boolean isEmpty() {
        return this.getInventory().isEmpty();
    }

    public ItemStack getItem(int slotId) {
        return this.getInventory().getItem(slotId);
    }

    public ItemStack removeItem(int slotId, int amount) {
        return this.getInventory().removeItem(slotId, amount);
    }

    public ItemStack removeItemNoUpdate(int slotId) {
        return this.getInventory().removeItemNoUpdate(slotId);
    }

    public void setItem(int slotId, ItemStack stack) {
        this.getInventory().setItem(slotId, stack);
    }

    public int getMaxStackSize() {
        return this.getInventory().getMaxStackSize();
    }

    public boolean stillValid(Player player) {
        return this.getInventory().stillValid(player);
    }

    public void startOpen(Player player) {
        this.getInventory().startOpen(player);
    }

    public void stopOpen(Player player) {
        this.getInventory().stopOpen(player);
    }

    public boolean canPlaceItem(int slotId, ItemStack stack) {
        return this.getInventory().canPlaceItem(slotId, stack);
    }

    public int countItem(Item item) {
        return this.getInventory().countItem(item);
    }

    public boolean hasAnyOf(Set<Item> item) {
        return this.getInventory().hasAnyOf(item);
    }

    public void clearContent() {
        this.getInventory().clearContent();
    }

    public int[] getSlotsForFace(Direction side) {
        Object t = this.getInventory();
        if (t instanceof WorldlyContainer) {
            WorldlyContainer worldy = (WorldlyContainer)t;
            return worldy.getSlotsForFace(side);
        }
        return this.fallbackSlots.get();
    }

    public boolean canPlaceItemThroughFace(int slotId, ItemStack stack, @Nullable Direction side) {
        Object t = this.getInventory();
        if (t instanceof WorldlyContainer) {
            WorldlyContainer worldly = (WorldlyContainer)t;
            return worldly.canPlaceItemThroughFace(slotId, stack, side);
        }
        return this.getInventory().canPlaceItem(slotId, stack) && this.getItem(slotId).getCount() < this.getMaxStackSize();
    }

    public boolean canTakeItemThroughFace(int slotId, ItemStack stack, Direction side) {
        Object t = this.getInventory();
        if (t instanceof WorldlyContainer) {
            WorldlyContainer worldly = (WorldlyContainer)t;
            return worldly.canTakeItemThroughFace(slotId, stack, side);
        }
        return true;
    }
}

