/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class SerializedBlockEntity
extends BlockEntity {
    public SerializedBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void saveAdditional(CompoundTag data) {
        super.saveAdditional(data);
        this.writeTileData(data);
    }

    public void load(CompoundTag data) {
        super.load(data);
        this.readTileData(data);
    }

    public CompoundTag getUpdateTag() {
        CompoundTag updateTag = super.getUpdateTag();
        this.writeTileData(updateTag);
        return updateTag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    abstract void writeTileData(CompoundTag var1);

    abstract void readTileData(CompoundTag var1);
}

