/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;

public final class WorldUtils {
    public static int getLoadedChunks(ServerWorld world) {
        return world.func_72863_F() != null ? world.func_72863_F().func_73152_e() : -1;
    }

    public static boolean areSameChunk(BlockPos first, BlockPos second) {
        return new ChunkPos(first).equals((Object)new ChunkPos(second));
    }

    public static List<Chunk> getNearbyChunks(World world, Chunk chunk) {
        return WorldUtils.getNearbyChunks(world, chunk.func_76632_l());
    }

    public static List<Chunk> getNearbyChunks(World world, ChunkPos chunk) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        for (int offX = -1; offX < 2; ++offX) {
            for (int offY = -1; offY < 2; ++offY) {
                chunks.add(world.func_212866_a_(chunk.field_77276_a + offX, chunk.field_77275_b + offY));
            }
        }
        return chunks;
    }

    public static boolean isWithinDistanceAndUsable(IWorldPosCallable worldPos, PlayerEntity player, Predicate<BlockState> statePredicate, double maxDistance) {
        return (Boolean)worldPos.func_221485_a((world, pos) -> statePredicate.test(world.func_180495_p(pos)) && player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= maxDistance, (Object)true);
    }

    public static boolean isSlimeChunk(ServerWorld world, BlockPos pos) {
        return SharedSeedRandom.func_205190_a((int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4), (long)world.func_72905_C(), (long)987234911L).nextInt(10) == 0;
    }

    public static int getWaterDepth(LivingEntity living, boolean toAir) {
        return WorldUtils.getWaterDepth(living.field_70170_p, new BlockPos(living.func_226277_ct_(), living.func_226278_cu_() + (double)living.func_70047_e(), living.func_226281_cx_()), toAir);
    }

    public static int getWaterDepth(World world, BlockPos startingPos, boolean toAir) {
        BlockPos.Mutable depthPos = startingPos.func_239590_i_();
        int depth = 0;
        while (!World.func_189509_E((BlockPos)depthPos) && (world.func_201671_F((BlockPos)depthPos) || toAir && !world.func_175623_d((BlockPos)depthPos))) {
            ++depth;
            depthPos.func_189536_c(Direction.UP);
        }
        return depth;
    }
}

