/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

@OnlyIn(value=Dist.CLIENT)
public final class RenderUtils {
    private static final Random RANDOM = new Random();
    private static final BitSet BITS = new BitSet(3);
    private static final Map<Block, RenderType> RENDER_TYPES = new HashMap<Block, RenderType>();

    public static TextureAtlasSprite getParticleSprite(ItemStack stack) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack).func_177554_e();
    }

    public TextureAtlasSprite getParticleSprite(BlockState state, World world, BlockPos pos) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().getTexture(state, world, pos);
    }

    public static TextureAtlasSprite getParticleSprite(BlockState state) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
    }

    public static IBakedModel getModel(ModelResourceLocation name) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174953_a(name);
    }

    public static IBakedModel getModel(ItemStack stack) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
    }

    public static IBakedModel getModel(BlockState state) {
        return Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
    }

    public static void renderModel(BlockModelRenderer renderer, IBlockDisplayReader world, IBakedModel model, BlockState state, BlockPos pos, MatrixStack matrix, IVertexBuilder buffer, Direction[] sides) {
        IModelData modelData = model.getModelData(world, pos, state, (IModelData)EmptyModelData.INSTANCE);
        for (Direction side : sides) {
            RANDOM.setSeed(0L);
            List sidedQuads = model.getQuads(state, side, RANDOM, modelData);
            if (sidedQuads.isEmpty()) continue;
            int lightForSide = WorldRenderer.func_228420_a_((IBlockDisplayReader)world, (BlockState)state, (BlockPos)pos.func_177972_a(side));
            renderer.func_228798_a_(world, state, pos, lightForSide, OverlayTexture.field_229196_a_, false, matrix, buffer, sidedQuads, BITS);
        }
        RANDOM.setSeed(0L);
        List unsidedQuads = model.getQuads(state, null, RANDOM, modelData);
        if (!unsidedQuads.isEmpty()) {
            renderer.func_228798_a_(world, state, pos, -1, OverlayTexture.field_229196_a_, true, matrix, buffer, unsidedQuads, BITS);
        }
    }

    public static String getName(RenderState state) {
        return state.field_228509_a_;
    }

    public static RenderType getRenderType(BlockState state) {
        return RENDER_TYPES.computeIfAbsent(state.func_177230_c(), k -> RenderUtils.findRenderType(state));
    }

    public static RenderType findRenderType(BlockState state) {
        for (RenderType blockType : RenderType.func_228661_n_()) {
            if (!RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)blockType)) continue;
            return blockType;
        }
        return RenderTypeLookup.func_239221_b_((BlockState)state);
    }
}

