/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import java.util.HashSet;
import java.util.List;
import net.darkhax.bookshelf.util.MathsUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public final class EntityUtils {
    public static double getDistanceFromEntity(Entity firstEntity, Entity secondEntity) {
        return MathsUtils.getDistanceBetweenPoints(firstEntity.func_213303_ch(), secondEntity.func_213303_ch());
    }

    public static double getDistaceFromPos(Entity entity, BlockPos pos) {
        return MathsUtils.getDistanceBetweenPoints(entity.func_213303_ch(), Vector3d.func_237489_a_((Vector3i)pos));
    }

    public static void pushTowards(Entity entityToMove, Direction direction, double force) {
        EntityUtils.pushTowards(entityToMove, entityToMove.func_233580_cy_().func_177967_a(direction.func_176734_d(), 1), force);
    }

    public static void pushTowards(Entity entityToMove, BlockPos pos, double force) {
        double distanceZ;
        double distanceY;
        BlockPos entityPos = entityToMove.func_233580_cy_();
        double distanceX = (double)pos.func_177958_n() - (double)entityPos.func_177958_n();
        double distance = Math.sqrt(distanceX * distanceX + (distanceY = (double)pos.func_177956_o() - (double)entityPos.func_177956_o()) * distanceY + (distanceZ = (double)pos.func_177952_p() - (double)entityPos.func_177952_p()) * distanceZ);
        if (distance > 0.0) {
            entityToMove.func_213317_d(new Vector3d(distanceX / distance * force, distanceY / distance * force, distanceZ / distance * force));
        }
    }

    public static void pushTowards(Entity entityToMove, Entity destination, double force) {
        double distanceZ;
        double distanceY;
        double distanceX = destination.func_226277_ct_() - entityToMove.func_226277_ct_();
        double distance = Math.sqrt(distanceX * distanceX + (distanceY = destination.func_226278_cu_() - entityToMove.func_226278_cu_()) * distanceY + (distanceZ = destination.func_226281_cx_() - entityToMove.func_226281_cx_()) * distanceZ);
        if (distance > 0.0) {
            entityToMove.func_213317_d(new Vector3d(distanceX / distance * force, distanceY / distance * force, distanceZ / distance * force));
        }
    }

    public static void pushTowardsDirection(Entity entityToMove, Direction direction, double force) {
        double distanceZ;
        double distanceY;
        BlockPos entityPos = entityToMove.func_233580_cy_();
        BlockPos destination = entityToMove.func_233580_cy_().func_177967_a(direction.func_176734_d(), 1);
        double distanceX = (double)destination.func_177958_n() - (double)entityPos.func_177958_n();
        double distance = Math.sqrt(distanceX * distanceX + (distanceY = (double)destination.func_177956_o() - (double)entityPos.func_177956_o()) * distanceY + (distanceZ = (double)destination.func_177952_p() - (double)entityPos.func_177952_p()) * distanceZ);
        if (distance > 0.0) {
            entityToMove.func_213317_d(new Vector3d(distanceX / distance * force, distanceY / distance * force, distanceZ / distance * force));
        }
    }

    public static boolean areEntitiesCloseEnough(Entity firstEntity, Entity secondEntity, double maxDistance) {
        return EntityUtils.getDistanceFromEntity(firstEntity, secondEntity) < maxDistance * maxDistance;
    }

    public static <T extends Entity> List<T> getEntitiesInArea(Class<T> entityClass, World world, BlockPos pos, int range) {
        return EntityUtils.getEntitiesInArea(entityClass, world, pos, (float)range);
    }

    public static <T extends Entity> List<T> getEntitiesInArea(Class<T> entityClass, World world, BlockPos pos, float range) {
        return world.func_217357_a(entityClass, new AxisAlignedBB(pos.func_177963_a((double)(-range), (double)(-range), (double)(-range)), pos.func_177963_a((double)(range + 1.0f), (double)(range + 1.0f), (double)(range + 1.0f))));
    }

    public static boolean isWearingFullSet(MobEntity living, Class<Item> armorClass) {
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            ItemStack armor;
            if (!slot.func_188453_a().equals((Object)EquipmentSlotType.Group.ARMOR) || !(armor = living.func_184582_a(slot)).func_190926_b() && armor.func_77973_b().getClass().equals(armorClass)) continue;
            return false;
        }
        return true;
    }

    public static RayTraceResult rayTrace(LivingEntity entity, double length, RayTraceContext.BlockMode blockMode, RayTraceContext.FluidMode fluidMode) {
        Vector3d startingPosition = new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e(), entity.func_226281_cx_());
        Vector3d lookVector = entity.func_70040_Z();
        Vector3d endingPosition = startingPosition.func_72441_c(lookVector.field_72450_a * length, lookVector.field_72448_b * length, lookVector.field_72449_c * length);
        return entity.field_70170_p.func_217299_a(new RayTraceContext(startingPosition, endingPosition, blockMode, fluidMode, (Entity)entity));
    }

    public static boolean isAffectedByFire(LivingEntity toCheck) {
        return !toCheck.func_230279_az_() && !toCheck.func_70644_a(Effects.field_76426_n);
    }

    public static void clearEffects(LivingEntity entity, boolean removePositive, boolean removeNegative) {
        HashSet<Effect> toClear = new HashSet<Effect>();
        for (EffectInstance effectInstance : entity.func_70651_bq()) {
            boolean isGood = effectInstance.func_188419_a().func_188408_i();
            if ((!isGood || !removePositive) && (isGood || !removeNegative)) continue;
            toClear.add(effectInstance.func_188419_a());
        }
        for (Effect effect : toClear) {
            entity.func_195063_d(effect);
        }
    }
}

