/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.crafting.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.Map;
import net.darkhax.bookshelf.util.InventoryUtils;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ShapedRecipeDamaging
extends ShapedRecipe {
    public static final IRecipeSerializer<?> SERIALIZER = new Serializer();
    private final int damageAmount;
    private final boolean ignoreUnbreaking;

    public ShapedRecipeDamaging(ResourceLocation id, String group, int width, int height, NonNullList<Ingredient> input, ItemStack output, int damageAmount, boolean ignoreUnbreaking) {
        super(id, group, width, height, input, output);
        this.damageAmount = damageAmount;
        this.ignoreUnbreaking = ignoreUnbreaking;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList keptItems = super.func_179532_b((IInventory)inv);
        return InventoryUtils.keepDamageableItems(inv, (NonNullList<ItemStack>)keptItems, this.ignoreUnbreaking, this.damageAmount);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ShapedRecipeDamaging> {
        private Serializer() {
        }

        public ShapedRecipeDamaging read(ResourceLocation recipeId, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            Map ingredients = ShapedRecipe.func_192408_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"key"));
            String[] pattern = ShapedRecipe.func_194134_a((String[])ShapedRecipe.func_192407_a((JsonArray)JSONUtils.func_151214_t((JsonObject)json, (String)"pattern")));
            int width = pattern[0].length();
            int height = pattern.length;
            NonNullList inputs = ShapedRecipe.func_192402_a((String[])pattern, (Map)ingredients, (int)width, (int)height);
            ItemStack output = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            int damageAmount = JSONUtils.func_151208_a((JsonObject)json, (String)"damageAmount", (int)1);
            boolean ignoreUnbreaking = JSONUtils.func_151209_a((JsonObject)json, (String)"ignoreUnbreaking", (boolean)false);
            return new ShapedRecipeDamaging(recipeId, group, width, height, (NonNullList<Ingredient>)inputs, output, damageAmount, ignoreUnbreaking);
        }

        public ShapedRecipeDamaging read(ResourceLocation recipeId, PacketBuffer buffer) {
            int width = buffer.readInt();
            int height = buffer.readInt();
            String group = buffer.func_218666_n();
            NonNullList input = NonNullList.func_191197_a((int)(width * height), (Object)Ingredient.field_193370_a);
            for (int i = 0; i < input.size(); ++i) {
                input.set(i, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ItemStack output = buffer.func_150791_c();
            int damageAmount = buffer.readInt();
            boolean ignoreUnbreaking = buffer.readBoolean();
            return new ShapedRecipeDamaging(recipeId, group, width, height, (NonNullList<Ingredient>)input, output, damageAmount, ignoreUnbreaking);
        }

        public void write(PacketBuffer buffer, ShapedRecipeDamaging recipe) {
            buffer.writeInt(recipe.func_192403_f());
            buffer.writeInt(recipe.func_192404_g());
            buffer.func_180714_a(recipe.func_193358_e());
            for (Ingredient ingredient : recipe.func_192400_c()) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_150788_a(recipe.func_77571_b());
            buffer.writeInt(recipe.damageAmount);
            buffer.writeBoolean(recipe.ignoreUnbreaking);
        }
    }
}

