/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.loot.modifier;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.darkhax.bookshelf.Bookshelf;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;

public class ModifierRecipe
extends LootModifier {
    public static final GlobalLootModifierSerializer CRAFTING = ModifierRecipe.createModifier(conditions -> new ModifierRecipe((ILootCondition[])conditions, IRecipeType.field_222149_a));
    public static final GlobalLootModifierSerializer SMELTING = ModifierRecipe.createModifier(conditions -> new ModifierRecipe((ILootCondition[])conditions, IRecipeType.field_222150_b));
    public static final GlobalLootModifierSerializer BLASTING = ModifierRecipe.createModifier(conditions -> new ModifierRecipe((ILootCondition[])conditions, IRecipeType.field_222151_c));
    public static final GlobalLootModifierSerializer SMOKING = ModifierRecipe.createModifier(conditions -> new ModifierRecipe((ILootCondition[])conditions, IRecipeType.field_222152_d));
    public static final GlobalLootModifierSerializer CAMPFIRE = ModifierRecipe.createModifier(conditions -> new ModifierRecipe((ILootCondition[])conditions, IRecipeType.field_222153_e));
    public static final GlobalLootModifierSerializer STONECUT = ModifierRecipe.createModifier(conditions -> new ModifierRecipe((ILootCondition[])conditions, IRecipeType.field_222154_f));
    public static final GlobalLootModifierSerializer SMITHING = ModifierRecipe.createModifier(conditions -> new ModifierRecipe((ILootCondition[])conditions, IRecipeType.field_234827_g_));
    private final IRecipeType recipeType;

    public ModifierRecipe(ILootCondition[] conditions, IRecipeType type) {
        super(conditions);
        this.recipeType = type;
    }

    @Nonnull
    public List<ItemStack> doApply(List<ItemStack> loot, LootContext ctx) {
        return loot.stream().map(stack -> this.craft((ItemStack)stack, ctx)).collect(Collectors.toList());
    }

    private ItemStack craft(ItemStack stack, LootContext ctx) {
        try {
            ItemStack output;
            IRecipe recipe;
            List matchingRecipes = ctx.func_202879_g().func_199532_z().func_215370_b(this.recipeType, (IInventory)new Inventory(new ItemStack[]{stack}), (World)ctx.func_202879_g());
            if (!matchingRecipes.isEmpty() && (recipe = (IRecipe)matchingRecipes.get(ctx.func_202879_g().field_73012_v.nextInt(matchingRecipes.size()))) != null && (output = recipe.func_77571_b()) != null && !output.func_190926_b()) {
                return output;
            }
        }
        catch (Exception e) {
            Bookshelf.LOG.error("The following error is with another mod or your configs. Do not report it to Bookshelf!");
            Bookshelf.LOG.catching((Throwable)e);
        }
        return stack;
    }

    public static GlobalLootModifierSerializer<ModifierRecipe> createModifier(final Function<ILootCondition[], ModifierRecipe> function) {
        return new GlobalLootModifierSerializer<ModifierRecipe>(){

            public ModifierRecipe read(ResourceLocation location, JsonObject object, ILootCondition[] ailootcondition) {
                return (ModifierRecipe)((Object)function.apply(ailootcondition));
            }
        };
    }
}

