/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootTableManager;

public final class WorldUtils {
    public static int getLoadedChunks(ServerWorld world) {
        return world.func_72863_F() != null ? world.func_72863_F().func_73152_e() : -1;
    }

    public static boolean areSameChunk(BlockPos first, BlockPos second) {
        return new ChunkPos(first).equals((Object)new ChunkPos(second));
    }

    public static List<Chunk> getNearbyChunks(World world, Chunk chunk) {
        return WorldUtils.getNearbyChunks(world, chunk.func_76632_l());
    }

    public static List<Chunk> getNearbyChunks(World world, ChunkPos chunk) {
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        for (int offX = -1; offX < 2; ++offX) {
            for (int offY = -1; offY < 2; ++offY) {
                chunks.add(world.func_212866_a_(chunk.field_77276_a + offX, chunk.field_77275_b + offY));
            }
        }
        return chunks;
    }

    public static boolean isWithinDistanceAndUsable(IWorldPosCallable worldPos, PlayerEntity player, Predicate<BlockState> statePredicate, double maxDistance) {
        return (Boolean)worldPos.func_221485_a((world, pos) -> statePredicate.test(world.func_180495_p(pos)) && player.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5) <= maxDistance, (Object)true);
    }

    public static <T extends IRecipe<?>> Map<ResourceLocation, T> getRecipes(IRecipeType<T> recipeType, RecipeManager manager) {
        return manager.field_199522_d.getOrDefault(recipeType, Collections.emptyMap());
    }

    public static <T extends IRecipe<?>> List<T> getRecipeList(IRecipeType<T> recipeType, RecipeManager manager) {
        return WorldUtils.getRecipeList(recipeType, manager, Comparator.comparing(recipe -> recipe.func_77571_b().func_77977_a()));
    }

    public static <T extends IRecipe<?>> List<T> getRecipeList(IRecipeType<T> recipeType, RecipeManager manager, Comparator<T> comparator) {
        return WorldUtils.getRecipes(recipeType, manager).values().stream().sorted(comparator).collect(Collectors.toList());
    }

    public static boolean doesLootTableExist(ServerWorld world, ResourceLocation tableId) {
        return WorldUtils.doesLootTableExist(world.func_73046_m().func_200249_aQ(), tableId);
    }

    public static boolean doesLootTableExist(LootTableManager manager, ResourceLocation tableId) {
        return manager.field_186527_c.containsKey(tableId);
    }
}

