/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.registry;

import java.util.HashMap;
import java.util.Map;
import net.darkhax.bookshelf.registry.RegistryHelper;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.apache.logging.log4j.Logger;

public class RegistryHelperClient
extends RegistryHelper {
    private final Map<Class<? extends TileEntity>, TileEntityRenderer<? super TileEntity>> tileEntityRenderers = new HashMap<Class<? extends TileEntity>, TileEntityRenderer<? super TileEntity>>();
    private final Map<ContainerType<? extends Container>, ScreenManager.IScreenFactory> guis = new HashMap<ContainerType<? extends Container>, ScreenManager.IScreenFactory>();
    private final Map<Class<? extends Entity>, IRenderFactory> entityRenderers = new HashMap<Class<? extends Entity>, IRenderFactory>();
    private final Map<ResourceLocation, ModelFactory> modelFactories = new HashMap<ResourceLocation, ModelFactory>();

    public RegistryHelperClient(String modid, Logger logger, ItemGroup group) {
        super(modid, logger, group);
    }

    @Override
    public void initialize(IEventBus modBus) {
        super.initialize(modBus);
        modBus.addListener(this::onClientSetup);
        if (!this.modelFactories.isEmpty()) {
            modBus.addListener(this::applyModelFactories);
        }
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        if (!this.tileEntityRenderers.isEmpty()) {
            this.registerTileEntityRenderers();
        }
        if (!this.entityRenderers.isEmpty()) {
            this.registerEntityRenderers();
        }
    }

    public void setSpecialRenderer(Class<? extends TileEntity> tileEntityClass, TileEntityRenderer specialRenderer) {
        this.tileEntityRenderers.put(tileEntityClass, (TileEntityRenderer<? super TileEntity>)specialRenderer);
    }

    private void registerTileEntityRenderers() {
        if (!this.tileEntityRenderers.isEmpty()) {
            this.logger.info("Registering {} TileEntity Renderers.", (Object)this.tileEntityRenderers.size());
            for (Map.Entry<Class<? extends TileEntity>, TileEntityRenderer<? super TileEntity>> entry : this.tileEntityRenderers.entrySet()) {
                ClientRegistry.bindTileEntitySpecialRenderer(entry.getKey(), entry.getValue());
            }
        }
    }

    public <M extends Container, U extends Screen> void registerGuiScreen(ContainerType<? extends M> containerType, ScreenManager.IScreenFactory<M, U> factory) {
        this.guis.put(containerType, factory);
    }

    @Override
    protected void registerContainerTypes(RegistryEvent.Register<ContainerType<?>> event) {
        super.registerContainerTypes(event);
        if (!this.guis.isEmpty()) {
            this.logger.info("Registering {} GUI screens.", (Object)this.guis.size());
            for (Map.Entry<ContainerType<? extends Container>, ScreenManager.IScreenFactory> entry : this.guis.entrySet()) {
                ScreenManager.func_216911_a(entry.getKey(), (ScreenManager.IScreenFactory)entry.getValue());
            }
        }
    }

    public void registerEntityRenderer(Class<? extends Entity> clazz, IRenderFactory renderFactory) {
        this.entityRenderers.put(clazz, renderFactory);
    }

    private void registerEntityRenderers() {
        this.logger.info("Registering {} entity renderers.", (Object)this.entityRenderers.size());
        for (Map.Entry<Class<? extends Entity>, IRenderFactory> entry : this.entityRenderers.entrySet()) {
            RenderingRegistry.registerEntityRenderingHandler(entry.getKey(), (IRenderFactory)entry.getValue());
        }
    }

    public void registerModelFactory(ResourceLocation modelId, ModelFactory factory) {
        this.modelFactories.put(modelId, factory);
    }

    public void registerModel(ResourceLocation modelId, IBakedModel model) {
        this.registerModelFactory(modelId, (base, registry) -> model);
    }

    private void applyModelFactories(ModelBakeEvent event) {
        Map registry = event.getModelRegistry();
        for (ResourceLocation id : registry.keySet()) {
            ModelFactory factory = this.modelFactories.get(new ResourceLocation(id.func_110624_b(), id.func_110623_a()));
            if (factory == null) continue;
            registry.put(id, factory.createModel((IBakedModel)registry.get(id), event));
        }
    }

    @FunctionalInterface
    public static interface ModelFactory {
        public IBakedModel createModel(IBakedModel var1, ModelBakeEvent var2);
    }
}

